"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscalingJobRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const pascal_case_1 = require("pascal-case");
class GitlabRunnerAutoscalingJobRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.configuration = {
            ...props.configuration,
            token: props.configuration.token ?? props.token?.stringValue,
            name: props.configuration.name ?? GitlabRunnerAutoscalingJobRunner.generateUniqueName(),
        };
        this.instanceType = props.instanceType || aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T3, aws_ec2_1.InstanceSize.MICRO);
        this.machineImage =
            props.machineImage ||
                aws_ec2_1.MachineImage.genericLinux({
                    [scope.region]: new aws_ec2_1.LookupMachineImage({
                        name: "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*",
                        owners: ["099720109477"],
                        filters: {
                            architecture: ["x86_64"],
                            "image-type": ["machine"],
                            state: ["available"],
                            "root-device-type": ["ebs"],
                            "virtualization-type": ["hvm"],
                        },
                    }).getImage(scope).imageId,
                });
        this.role =
            props.role ||
                new aws_iam_1.Role(scope, `RunnersRoleFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
                    assumedBy: new aws_iam_1.ServicePrincipal("ec2.amazonaws.com", {}),
                    managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonSSMManagedInstanceCore")],
                });
        this.instanceProfile = new aws_iam_1.CfnInstanceProfile(scope, `RunnersInstanceProfileFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
            roles: [this.role.roleName],
        });
        if (props.keyPair && !props.configuration.machine?.machineOptions?.keypairName) {
            aws_cdk_lib_1.Annotations.of(this).addError("If runner.keyPair is configured, then props.configuration.machine.machineOptions.keypairName must also be set.");
        }
        this.keyPair = props.keyPair;
        aws_cdk_lib_1.Tags.of(this.role).add("RunnersRole", "RunnersRole");
    }
    static generateUniqueName() {
        return `gitlab-runner-${new Date().getTime().toString().toString()}${Math.floor(Math.random() * 100000)}`;
    }
}
exports.GitlabRunnerAutoscalingJobRunner = GitlabRunnerAutoscalingJobRunner;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscalingJobRunner[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.GitlabRunnerAutoscalingJobRunner", version: "0.2.174" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiam9iLXJ1bm5lci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ydW5uZXIvam9iLXJ1bm5lci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUF1RDtBQUN2RCxpREFPNkI7QUFDN0IsaURBQXVHO0FBR3ZHLDJDQUF1QztBQUN2Qyw2Q0FBeUM7QUFnRHpDLE1BQWEsZ0NBQWlDLFNBQVEsc0JBQVM7SUFXN0QsWUFBWSxLQUFZLEVBQUUsRUFBVSxFQUFFLEtBQTRDO1FBQ2hGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLGFBQWEsR0FBRztZQUNuQixHQUFHLEtBQUssQ0FBQyxhQUFhO1lBQ3RCLEtBQUssRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLEtBQUssSUFBSSxLQUFLLENBQUMsS0FBSyxFQUFFLFdBQVc7WUFDNUQsSUFBSSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxJQUFJLGdDQUFnQyxDQUFDLGtCQUFrQixFQUFFO1NBQ3hGLENBQUM7UUFDRixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLElBQUksc0JBQVksQ0FBQyxFQUFFLENBQUMsdUJBQWEsQ0FBQyxFQUFFLEVBQUUsc0JBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNoRyxJQUFJLENBQUMsWUFBWTtZQUNmLEtBQUssQ0FBQyxZQUFZO2dCQUNsQixzQkFBWSxDQUFDLFlBQVksQ0FBQztvQkFDeEIsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLEVBQUUsSUFBSSw0QkFBa0IsQ0FBQzt3QkFDckMsSUFBSSxFQUFFLHlEQUF5RDt3QkFDL0QsTUFBTSxFQUFFLENBQUMsY0FBYyxDQUFDO3dCQUN4QixPQUFPLEVBQUU7NEJBQ1AsWUFBWSxFQUFFLENBQUMsUUFBUSxDQUFDOzRCQUN4QixZQUFZLEVBQUUsQ0FBQyxTQUFTLENBQUM7NEJBQ3pCLEtBQUssRUFBRSxDQUFDLFdBQVcsQ0FBQzs0QkFDcEIsa0JBQWtCLEVBQUUsQ0FBQyxLQUFLLENBQUM7NEJBQzNCLHFCQUFxQixFQUFFLENBQUMsS0FBSyxDQUFDO3lCQUMvQjtxQkFDRixDQUFDLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU87aUJBQzNCLENBQUMsQ0FBQztRQUNMLElBQUksQ0FBQyxJQUFJO1lBQ1AsS0FBSyxDQUFDLElBQUk7Z0JBQ1YsSUFBSSxjQUFJLENBQUMsS0FBSyxFQUFFLGlCQUFpQix3QkFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSyxDQUFDLEVBQUUsRUFBRTtvQkFDdkUsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMsbUJBQW1CLEVBQUUsRUFBRSxDQUFDO29CQUN4RCxlQUFlLEVBQUUsQ0FBQyx1QkFBYSxDQUFDLHdCQUF3QixDQUFDLDhCQUE4QixDQUFDLENBQUM7aUJBQzFGLENBQUMsQ0FBQztRQUNMLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSw0QkFBa0IsQ0FDM0MsS0FBSyxFQUNMLDRCQUE0Qix3QkFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSyxDQUFDLEVBQUUsRUFDbEU7WUFDRSxLQUFLLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztTQUM1QixDQUNGLENBQUM7UUFFRixJQUFJLEtBQUssQ0FBQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxjQUFjLEVBQUUsV0FBVyxFQUFFO1lBQzlFLHlCQUFXLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsQ0FDM0IsZ0hBQWdILENBQ2pILENBQUM7U0FDSDtRQUNELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUU3QixrQkFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxhQUFhLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBdkRPLE1BQU0sQ0FBQyxrQkFBa0I7UUFDL0IsT0FBTyxpQkFBaUIsSUFBSSxJQUFJLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDO0lBQzVHLENBQUM7O0FBSEgsNEVBeURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQW5ub3RhdGlvbnMsIFN0YWNrLCBUYWdzIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQge1xuICBJTWFjaGluZUltYWdlLFxuICBJbnN0YW5jZUNsYXNzLFxuICBJbnN0YW5jZVNpemUsXG4gIEluc3RhbmNlVHlwZSxcbiAgTG9va3VwTWFjaGluZUltYWdlLFxuICBNYWNoaW5lSW1hZ2UsXG59IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtZWMyXCI7XG5pbXBvcnQgeyBDZm5JbnN0YW5jZVByb2ZpbGUsIElSb2xlLCBNYW5hZ2VkUG9saWN5LCBSb2xlLCBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1pYW1cIjtcbmltcG9ydCB7IElTZWNyZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLXNlY3JldHNtYW5hZ2VyXCI7XG5pbXBvcnQgeyBJU3RyaW5nUGFyYW1ldGVyIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1zc21cIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBwYXNjYWxDYXNlIH0gZnJvbSBcInBhc2NhbC1jYXNlXCI7XG5pbXBvcnQgeyBSdW5uZXJDb25maWd1cmF0aW9uIH0gZnJvbSBcIi4uL3J1bm5lci1jb25maWd1cmF0aW9uXCI7XG5cbi8qKlxuICogVGhlIHJ1bm5lciBFQzIgaW5zdGFuY2VzIGNvbmZpZ3VyYXRpb24uIElmIG5vdCBzZXQsIHRoZSBkZWZhdWx0cyB3aWxsIGJlIHVzZWQuXG4gKi9cblxuZXhwb3J0IGludGVyZmFjZSBHaXRsYWJSdW5uZXJBdXRvc2NhbGluZ0pvYlJ1bm5lclByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBydW5uZXLigJlzIGF1dGhlbnRpY2F0aW9uIHRva2VuLCB3aGljaCBpcyBvYnRhaW5lZCBkdXJpbmcgcnVubmVyIHJlZ2lzdHJhdGlvbi4gTm90IHRoZSBzYW1lIGFzIHRoZSByZWdpc3RyYXRpb24gdG9rZW4uXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmdpdGxhYi5jb20vZWUvYXBpL3J1bm5lcnMuaHRtbCNyZWdpc3Rlci1hLW5ldy1ydW5uZXJcbiAgICovXG4gIHJlYWRvbmx5IHRva2VuOiBJU3RyaW5nUGFyYW1ldGVyO1xuXG4gIC8qKlxuICAgKiBUaGUgcnVubmVyIEVDMiBpbnN0YW5jZXMgY29uZmlndXJhdGlvbi4gSWYgbm90IHNldCwgdGhlIGRlZmF1bHRzIHdpbGwgYmUgdXNlZC5cbiAgICogQGxpbmsgUnVubmVyQ29uZmlndXJhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgY29uZmlndXJhdGlvbjogUnVubmVyQ29uZmlndXJhdGlvbjtcbiAgLyoqXG4gICAqIEluc3RhbmNlIHR5cGUgZm9yIHJ1bm5lciBFQzIgaW5zdGFuY2VzLiBJdCdzIGEgY29tYmluYXRpb24gb2YgYSBjbGFzcyBhbmQgc2l6ZS5cbiAgICogQGRlZmF1bHQgSW5zdGFuY2VUeXBlLm9mKEluc3RhbmNlQ2xhc3MuVDMsIEluc3RhbmNlU2l6ZS5NSUNSTylcbiAgICovXG4gIHJlYWRvbmx5IGluc3RhbmNlVHlwZT86IEluc3RhbmNlVHlwZTtcbiAgLyoqXG4gICAqIEFuIEFtYXpvbiBNYWNoaW5lIEltYWdlIElEIGZvciB0aGUgUnVubmVycyBFQzIgaW5zdGFuY2VzLiBJZiBlbXB0eSB0aGUgbGF0ZXN0IFVidW50dSAyMC4wNCBmb2NhbCB3aWxsIGJlIGxvb2tlZCB1cC5cbiAgICpcbiAgICogQW55IG9wZXJhdGluZyBzeXN0ZW0gc3VwcG9ydGVkIGJ5IERvY2tlciBNYWNoaW5lJ3MgcHJvdmlzaW9uZXIuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9jbG91ZC1pbWFnZXMudWJ1bnR1LmNvbS9sb2NhdG9yL2VjMi9cbiAgICogQHNlZSBodHRwczovL2dpdGxhYi5jb20vZ2l0bGFiLW9yZy9jaS1jZC9kb2NrZXItbWFjaGluZS8tL3RyZWUvbWFpbi9saWJtYWNoaW5lL3Byb3Zpc2lvblxuICAgKi9cbiAgcmVhZG9ubHkgbWFjaGluZUltYWdlPzogSU1hY2hpbmVJbWFnZTtcbiAgLyoqXG4gICAqIE9wdGlvbmFsbHkgcGFzcyBhbiBJQU0gcm9sZSwgdGhhdCBnZXQncyBhc3NpZ25lZCB0byB0aGUgRUMyIHJ1bm5lciBpbnN0YW5jZXMgdmlhIEluc3RhbmNlIFByb2ZpbGUuXG4gICAqL1xuICByZWFkb25seSByb2xlPzogSVJvbGU7XG4gIC8qKlxuICAgKiBPcHRpb25hbGx5IHBhc3MgYSBjdXN0b20gRUMyIEtleVBhaXIsIHRoYXQgd2lsbCBiZSB1c2VkIGJ5IHRoZSBtYW5hZ2VyIHRvIGNvbm5lY3QgdG8gdGhlIGpvYiBydW5uZXIgaW5zdGFuY2VzLlxuICAgKlxuICAgKiA8b2w+XG4gICAqICAgPGxpPkV4YW1wbGU6IDxiPmF3cyBzZWNyZXRzbWFuYWdlciBjcmVhdGUtc2VjcmV0IC0tbmFtZSBBbnlLZXlQYWlyU2VjcmV0IC0tc2VjcmV0LXN0cmluZyBcIntcXFwidGhlS2V5UGFpck5hbWVcXFwiOlxcXCI8dGhlIHByaXZhdGUga2V5PlxcXCIsXFxcInRoZUtleVBhaXJOYW1lLnB1YlxcXCI6XFxcIjx0aGUgcHVibGljIGtleT5cXFwifVwiPC9iPjwvbGk+XG4gICAqICAgPGxpPjxiPkFkZGl0aW9uYWxseSBjb25maWd1cmUgYW4gdW5pcXVlIGtleSBwYWlyIGNvbmZpZ3VyYXRpb24ubWFjaGluZS5tYWNoaW5lT3B0aW9ucy5rZXlwYWlyTmFtZTwvYj48L2xpPlxuICAgKiA8L29sPlxuICAgKi9cbiAgcmVhZG9ubHkga2V5UGFpcj86IElTZWNyZXQ7XG59XG5cbmV4cG9ydCBjbGFzcyBHaXRsYWJSdW5uZXJBdXRvc2NhbGluZ0pvYlJ1bm5lciBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHByaXZhdGUgc3RhdGljIGdlbmVyYXRlVW5pcXVlTmFtZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiBgZ2l0bGFiLXJ1bm5lci0ke25ldyBEYXRlKCkuZ2V0VGltZSgpLnRvU3RyaW5nKCkudG9TdHJpbmcoKX0ke01hdGguZmxvb3IoTWF0aC5yYW5kb20oKSAqIDEwMDAwMCl9YDtcbiAgfVxuICByZWFkb25seSBjb25maWd1cmF0aW9uOiBSdW5uZXJDb25maWd1cmF0aW9uO1xuICByZWFkb25seSBpbnN0YW5jZVR5cGU6IEluc3RhbmNlVHlwZTtcbiAgcmVhZG9ubHkgbWFjaGluZUltYWdlOiBJTWFjaGluZUltYWdlO1xuICByZWFkb25seSByb2xlOiBJUm9sZTtcbiAgcmVhZG9ubHkgaW5zdGFuY2VQcm9maWxlOiBDZm5JbnN0YW5jZVByb2ZpbGU7XG4gIHJlYWRvbmx5IGtleVBhaXI/OiBJU2VjcmV0O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBTdGFjaywgaWQ6IHN0cmluZywgcHJvcHM6IEdpdGxhYlJ1bm5lckF1dG9zY2FsaW5nSm9iUnVubmVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMuY29uZmlndXJhdGlvbiA9IHtcbiAgICAgIC4uLnByb3BzLmNvbmZpZ3VyYXRpb24sXG4gICAgICB0b2tlbjogcHJvcHMuY29uZmlndXJhdGlvbi50b2tlbiA/PyBwcm9wcy50b2tlbj8uc3RyaW5nVmFsdWUsXG4gICAgICBuYW1lOiBwcm9wcy5jb25maWd1cmF0aW9uLm5hbWUgPz8gR2l0bGFiUnVubmVyQXV0b3NjYWxpbmdKb2JSdW5uZXIuZ2VuZXJhdGVVbmlxdWVOYW1lKCksXG4gICAgfTtcbiAgICB0aGlzLmluc3RhbmNlVHlwZSA9IHByb3BzLmluc3RhbmNlVHlwZSB8fCBJbnN0YW5jZVR5cGUub2YoSW5zdGFuY2VDbGFzcy5UMywgSW5zdGFuY2VTaXplLk1JQ1JPKTtcbiAgICB0aGlzLm1hY2hpbmVJbWFnZSA9XG4gICAgICBwcm9wcy5tYWNoaW5lSW1hZ2UgfHxcbiAgICAgIE1hY2hpbmVJbWFnZS5nZW5lcmljTGludXgoe1xuICAgICAgICBbc2NvcGUucmVnaW9uXTogbmV3IExvb2t1cE1hY2hpbmVJbWFnZSh7XG4gICAgICAgICAgbmFtZTogXCJ1YnVudHUvaW1hZ2VzL2h2bS1zc2QvdWJ1bnR1LWZvY2FsLTIwLjA0LWFtZDY0LXNlcnZlci0qXCIsXG4gICAgICAgICAgb3duZXJzOiBbXCIwOTk3MjAxMDk0NzdcIl0sXG4gICAgICAgICAgZmlsdGVyczoge1xuICAgICAgICAgICAgYXJjaGl0ZWN0dXJlOiBbXCJ4ODZfNjRcIl0sXG4gICAgICAgICAgICBcImltYWdlLXR5cGVcIjogW1wibWFjaGluZVwiXSxcbiAgICAgICAgICAgIHN0YXRlOiBbXCJhdmFpbGFibGVcIl0sXG4gICAgICAgICAgICBcInJvb3QtZGV2aWNlLXR5cGVcIjogW1wiZWJzXCJdLFxuICAgICAgICAgICAgXCJ2aXJ0dWFsaXphdGlvbi10eXBlXCI6IFtcImh2bVwiXSxcbiAgICAgICAgICB9LFxuICAgICAgICB9KS5nZXRJbWFnZShzY29wZSkuaW1hZ2VJZCxcbiAgICAgIH0pO1xuICAgIHRoaXMucm9sZSA9XG4gICAgICBwcm9wcy5yb2xlIHx8XG4gICAgICBuZXcgUm9sZShzY29wZSwgYFJ1bm5lcnNSb2xlRm9yJHtwYXNjYWxDYXNlKHRoaXMuY29uZmlndXJhdGlvbi5uYW1lISl9YCwge1xuICAgICAgICBhc3N1bWVkQnk6IG5ldyBTZXJ2aWNlUHJpbmNpcGFsKFwiZWMyLmFtYXpvbmF3cy5jb21cIiwge30pLFxuICAgICAgICBtYW5hZ2VkUG9saWNpZXM6IFtNYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZShcIkFtYXpvblNTTU1hbmFnZWRJbnN0YW5jZUNvcmVcIildLFxuICAgICAgfSk7XG4gICAgdGhpcy5pbnN0YW5jZVByb2ZpbGUgPSBuZXcgQ2ZuSW5zdGFuY2VQcm9maWxlKFxuICAgICAgc2NvcGUsXG4gICAgICBgUnVubmVyc0luc3RhbmNlUHJvZmlsZUZvciR7cGFzY2FsQ2FzZSh0aGlzLmNvbmZpZ3VyYXRpb24ubmFtZSEpfWAsXG4gICAgICB7XG4gICAgICAgIHJvbGVzOiBbdGhpcy5yb2xlLnJvbGVOYW1lXSxcbiAgICAgIH1cbiAgICApO1xuXG4gICAgaWYgKHByb3BzLmtleVBhaXIgJiYgIXByb3BzLmNvbmZpZ3VyYXRpb24ubWFjaGluZT8ubWFjaGluZU9wdGlvbnM/LmtleXBhaXJOYW1lKSB7XG4gICAgICBBbm5vdGF0aW9ucy5vZih0aGlzKS5hZGRFcnJvcihcbiAgICAgICAgXCJJZiBydW5uZXIua2V5UGFpciBpcyBjb25maWd1cmVkLCB0aGVuIHByb3BzLmNvbmZpZ3VyYXRpb24ubWFjaGluZS5tYWNoaW5lT3B0aW9ucy5rZXlwYWlyTmFtZSBtdXN0IGFsc28gYmUgc2V0LlwiXG4gICAgICApO1xuICAgIH1cbiAgICB0aGlzLmtleVBhaXIgPSBwcm9wcy5rZXlQYWlyO1xuXG4gICAgVGFncy5vZih0aGlzLnJvbGUpLmFkZChcIlJ1bm5lcnNSb2xlXCIsIFwiUnVubmVyc1JvbGVcIik7XG4gIH1cbn1cbiJdfQ==