# generated by datamodel-codegen:
#   filename:  type/tableQuery.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from . import basic


class TableQuery(BaseModel):
    query: str = Field(..., description='SQL query')
    userName: Optional[str] = Field(
        None, description='Name of the user that executed the SQL query'
    )
    startTime: Optional[str] = Field(
        None, description='Start time of execution of SQL query'
    )
    endTime: Optional[str] = Field(
        None, description='End time of execution of SQL query'
    )
    analysisDate: Optional[basic.DateTime] = Field(
        None, description='Date of execution of SQL query'
    )
    aborted: Optional[bool] = Field(
        None, description='Flag to check if query was aborted during execution'
    )
    serviceName: str = Field(
        ..., description='Name that identifies this database service.'
    )
    databaseName: Optional[str] = Field(
        None, description='Database associated with the table in the query'
    )
    databaseSchema: Optional[str] = Field(
        None, description='Database schema of the associated with query'
    )
    duration: Optional[float] = Field(
        None, description='How long did the query took to run in seconds.'
    )


class TableQueries(BaseModel):
    class Config:
        extra = Extra.forbid

    queries: Optional[List[TableQuery]] = Field(
        None, description='Date of execution of SQL query'
    )
