# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceProfilerPipeline.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..entity.data import table
from ..type import filterPattern


class ProfilerConfigType(Enum):
    Profiler = 'Profiler'


class DatabaseServiceProfilerPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ProfilerConfigType] = Field(
        ProfilerConfigType.Profiler, description='Pipeline type'
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
    generateSampleData: Optional[bool] = Field(
        True, description='Option to turn on/off generating sample data.'
    )
    profileSample: Optional[float] = Field(
        None,
        description='Percentage of data or no. of rows we want to execute the profiler and tests on',
    )
    profileSampleType: Optional[
        table.ProfileSampleType
    ] = table.ProfileSampleType.PERCENTAGE
    threadCount: Optional[float] = Field(
        5, description='Number of threads to use during metric computations'
    )
    timeoutSeconds: Optional[int] = Field(
        43200, description='Profiler Timeout in Seconds'
    )
