# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/kafkaConnection.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from .. import connectionBasicType


class KafkaType(Enum):
    Kafka = 'Kafka'


class KafkaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[KafkaType] = Field(
        KafkaType.Kafka, description='Service Type', title='Service Type'
    )
    bootstrapServers: str = Field(
        ...,
        description='Kafka bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
        title='Bootstrap Servers',
    )
    schemaRegistryURL: Optional[AnyUrl] = Field(
        None,
        description='Confluent Kafka Schema Registry URL.',
        title='Schema Registry URL',
    )
    consumerConfig: Optional[Dict[str, Any]] = Field(
        {},
        description='Confluent Kafka Consumer Config. From https://github.com/edenhill/librdkafka/blob/master/CONFIGURATION.md',
        title='Consumer Config',
    )
    schemaRegistryConfig: Optional[Dict[str, Any]] = Field(
        {},
        description='Confluent Kafka Schema Registry Config. From https://docs.confluent.io/5.5.1/clients/confluent-kafka-python/index.html#confluent_kafka.schema_registry.SchemaRegistryClient',
        title='Schema Registry Config',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
