# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/dynamoDBConnection.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .....security.credentials import awsCredentials
from .. import connectionBasicType


class DynamoDBType(Enum):
    DynamoDB = 'DynamoDB'


class DynamoDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DynamoDBType] = Field(
        DynamoDBType.DynamoDB, description='Service Type', title='Service Type'
    )
    awsConfig: awsCredentials.AWSCredentials = Field(
        ..., title='AWS Credentials Configuration'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
