# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/deltaLakeConnection.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType


class DeltaLakeType(Enum):
    DeltaLake = 'DeltaLake'


class MetastoreHostPortConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    metastoreHostPort: Optional[str] = Field(
        None,
        description='Thrift connection to the metastore service. E.g., localhost:9083',
        title='Hive Metastore Service',
    )


class MetastoreDbConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    metastoreDb: Optional[str] = Field(
        None,
        description='JDBC connection to the metastore database. E.g., jdbc:mysql://localhost:3306/demo_hive',
        title='Hive Metastore Database',
    )


class MetastoreFilePathConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    metastoreFilePath: Optional[str] = Field(
        None,
        description='Local path for the local file with metastore data. E.g., /tmp/metastore.db',
        title='Hive Metastore File Path',
    )


class DeltaLakeConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DeltaLakeType] = Field(
        DeltaLakeType.DeltaLake, description='Service Type', title='Service Type'
    )
    metastoreConnection: Union[
        MetastoreHostPortConnection, MetastoreDbConnection, MetastoreFilePathConnection
    ] = Field(
        ...,
        description='Hive metastore service, local file path or metastore db.',
        title='Hive Metastore Connection',
    )
    appName: Optional[str] = Field(
        None, description='pySpark App Name.', title='Application Name'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None,
        description='Key-Value pairs that will be used to add configs to the SparkSession.',
        title='Connection Arguments',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
