# generated by datamodel-codegen:
#   filename:  configuration/elasticSearchConfiguration.json
#   timestamp: 2023-02-27T17:11:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field


class SearchIndexMappingLanguage(Enum):
    EN = 'EN'
    JP = 'JP'


class ElasticSearchConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    host: str = Field(..., description='Elastic Search Host')
    port: int = Field(..., description='Elastic Search port')
    scheme: str = Field(..., description='Http/Https connection scheme')
    username: Optional[str] = Field(
        None, description='Elastic Search Username for Login'
    )
    password: Optional[str] = Field(
        None, description='Elastic Search Password for Login'
    )
    truststorePath: Optional[str] = Field(None, description='Truststore Path')
    truststorePassword: Optional[str] = Field(None, description='Truststore Password')
    connectionTimeoutSecs: int = Field(..., description='Connection Timeout in Seconds')
    socketTimeoutSecs: int = Field(..., description='Socket Timeout in Seconds')
    batchSize: int = Field(..., description='Batch Size for Requests')
    searchIndexMappingLanguage: SearchIndexMappingLanguage
