# `TC003` - Avoid specifying messages outside exception class

## Why is it bad

Code gets WET and is more prone to be inconsistent across the system.

## How it looks like

```py
class ArgCantBeEven(Exception):
    pass

def first_function(a: int):
    if a % 2 == 0:
        raise ArgCantBeEven(f"The argument '{a}' should be even")

def another_function(num: int):
    if a % 2 == 0:
        raise ArgCantBeEven(f"The argument {a} should not be odd.")
```

## How it should be

```py
class ArgCantBeEven(Exception):
    def __init__(self, arg: int):
        super().__init__(f"The argument '{a}' should be even")

def first_function(a: int):
    if a % 2 == 0:
        raise ArgCantBeEven(a)

def another_function(num: int):
    if num % 2 == 0:
        raise ArgCantBeEven(num)
```
