import re


# There's quite a lot wrong here, but it'll do for now.
# Wow, looking back on this, this is still horrific.
CARAT_FIX = re.compile(r"(?<!\\)\[\^\]")
NAMED_GROUP_FIX = re.compile(r"(?<!\\)\(\?<(\w+)>")
HYPHEN_FIX_1 = re.compile(r"(?<!\\)(\[[^\]]*(?<!\\)\\[wsdWSD])-")
HYPHEN_FIX_2 = re.compile(r"(?<!\\)(\[[^\]]*(?<!\\))-(\\[wsdWSD])")


def fix_js_regex(pattern: str) -> str:
    """Alter a javascript regex so that python can parse it. May accidentally alter meaning."""
    pattern = CARAT_FIX.sub(r"\^", pattern)
    pattern = NAMED_GROUP_FIX.sub(r"(?P<\1>", pattern)
    pattern = HYPHEN_FIX_1.sub(r"\1\-", pattern)
    pattern = HYPHEN_FIX_2.sub(r"\1\-\2", pattern)
    return pattern
