#!/usr/bin/env node
const cli = require('./cli'),
 readline = require('readline');

const args = process.argv.slice(2);


if (args.length == 1 && args[0] == '-') {
  process.stdin.setEncoding('utf-8');
  let data = '';
  readline.createInterface({ input: process.stdin }).
    on('line', (line) => (data += line)).
    on('close', () => {
      for (const output of cli.parseCode(data)) {
        console.log(output);
      }
    })
} else {
  (async () => {
    for (const filename of args) {
      for await (const output of cli.parseFile(filename)) {
        console.log(output);
      }
    }
  })()
}
