const parser = require('@typescript-eslint/parser');

module.exports = {
    * extractRegexesFromSource(content, filename) {
        // options https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/types/src/parser-options.ts
        const tree = parser.parse(content, {
            ecmaFeatures: {
                jsx: true
            },
            comment: false,
            ecmaVersion: 2020,
            errorOnTypeScriptSyntacticAndSemanticIssues: false,
            errorOnUnknownASTType: false,
            range: true,
            loc: true,
            filename,
        });
        yield* this.walkASTForRegexes(tree);
    },

    * walkASTForRegexes(tree) {
        if (!tree) {
            return;
        }
        if (tree.regex) {
            yield {
                'pattern': tree.regex.pattern,
                'flags': tree.regex.flags,
                'lineno': tree.loc.start.line,
            }
            return;
        }
        if (
            (tree.type == 'NewExpression' || tree.type == 'CallExpression') &&
            tree.callee && tree.callee.name == 'RegExp' && tree.arguments && tree.arguments[0].type == 'Literal'
        ) {
            yield {
                'pattern': tree.arguments[0].value,
                'flags': tree.arguments.length > 1 && tree.arguments[1].type == 'Literal' ? tree.arguments[1].value : '',
                'lineno': tree.loc.start.line,
            }
            return;
        }
        for (const element of Object.values(tree)) {
            if (element && typeof element == 'object') {
                yield* this.walkASTForRegexes(element);
            }
        }
    }
}
