const fs = require('fs').promises;
const findRegex = require('./find');

module.exports = {
  async * parseFile(filename) {
    try {
      const code = await fs.readFile(filename)
      yield* this.parseCode(code, filename);
    } catch (error) {
      yield JSON.stringify({ error, filename });
    }
  },

  * parseCode(code, filename) {
    try {
      for (const regex of findRegex.extractRegexesFromSource(code, filename)) {
        yield JSON.stringify({
          ...regex,
          filename,
        });
      }
    } catch (error) {
      yield JSON.stringify({ error, filename });
    }
  }
}
