# pylint: disable=trailing-newlines
# pylint: disable=line-too-long
# pylint: disable=too-many-lines
# pylint: disable=unused-import
# pylint: disable=invalid-name

r"""
Copyright &copy; 2020 NetApp Inc.
All rights reserved.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema


__all__ = ["Log", "LogSchema"]
__pdoc__ = {
    "LogSchema.resource": False,
    "Log": False,
}


class LogSchema(ResourceSchema):
    """The fields of the Log object"""

    links = fields.Nested("netapp_ontap.models.self_link.SelfLinkSchema", unknown=EXCLUDE, data_key="_links")
    r""" The links field of the log. """

    format = fields.Str(data_key="format")
    r""" The format in which the logs are generated by consolidation process.
  Possible values are:

  * xml  - Data ONTAP-specific XML log format
  * evtx - Microsoft Windows EVTX log format


Valid choices:

* xml
* evtx """

    retention = fields.Nested("netapp_ontap.models.log_retention.LogRetentionSchema", unknown=EXCLUDE, data_key="retention")
    r""" The retention field of the log. """

    rotation = fields.Nested("netapp_ontap.models.rotation.RotationSchema", unknown=EXCLUDE, data_key="rotation")
    r""" The rotation field of the log. """

    @property
    def resource(self):
        return Log

    @property
    def patchable_fields(self):
        return [
            "format",
            "retention",
            "rotation",
        ]

    @property
    def postable_fields(self):
        return [
            "format",
            "retention",
            "rotation",
        ]


class Log(Resource):  # pylint: disable=missing-docstring

    _schema = LogSchema
