# pylint: disable=trailing-newlines
# pylint: disable=line-too-long
# pylint: disable=too-many-lines
# pylint: disable=unused-import
# pylint: disable=invalid-name

r"""
Copyright &copy; 2020 NetApp Inc.
All rights reserved.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema


__all__ = ["ClusterPeerSetup", "ClusterPeerSetupSchema"]
__pdoc__ = {
    "ClusterPeerSetupSchema.resource": False,
    "ClusterPeerSetup": False,
}


class ClusterPeerSetupSchema(ResourceSchema):
    """The fields of the ClusterPeerSetup object"""

    links = fields.Nested("netapp_ontap.models.self_link.SelfLinkSchema", unknown=EXCLUDE, data_key="_links")
    r""" The links field of the cluster_peer_setup. """

    authentication = fields.Nested("netapp_ontap.models.cluster_peer_setup_response_authentication.ClusterPeerSetupResponseAuthenticationSchema", unknown=EXCLUDE, data_key="authentication")
    r""" The authentication field of the cluster_peer_setup. """

    ip_address = fields.Str(data_key="ip_address")
    r""" A local intercluster IP address that a remote cluster can use, together with the passphrase, to create a cluster peer relationship with the local cluster. """

    name = fields.Str(data_key="name")
    r""" Optional name for the cluster peer relationship. By default, it is the name of the remote cluster, or a temporary name might be autogenerated for anonymous cluster peer offers.

Example: cluster2 """

    @property
    def resource(self):
        return ClusterPeerSetup

    @property
    def patchable_fields(self):
        return [
            "authentication",
            "ip_address",
            "name",
        ]

    @property
    def postable_fields(self):
        return [
            "authentication",
            "ip_address",
            "name",
        ]


class ClusterPeerSetup(Resource):  # pylint: disable=missing-docstring

    _schema = ClusterPeerSetupSchema
