# Generated by Django 3.1.4 on 2020-12-29 17:20

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import unchained_chat.models
import unchained_utils.v0.base_classes


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ChatRoom',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('id', models.CharField(default=unchained_chat.models.generate_chatroom_code, editable=False, max_length=20, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=30, unique=True)),
                ('timestamp', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('users', unchained_utils.v0.base_classes.LooseManyToManyField(db_constraint=False, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-timestamp',),
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=100)),
                ('message', models.TextField()),
                ('timestamp', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('room', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='unchained_chat.chatroom')),
            ],
            options={
                'ordering': ('timestamp',),
            },
        ),
    ]
