#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.project import ProjectFragment, QUERY as ProjectFragmentQuery


# fmt: off
QUERY: List[str] = ProjectFragmentQuery + ["""
query ProjectsQuery {
  projects {
    edges {
      node {
        ...ProjectFragment
      }
    }
  }
}
"""
]


class ProjectsQuery:
    @dataclass(frozen=True)
    class ProjectsQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ProjectConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ProjectEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Project(ProjectFragment):
                    pass

                node: Optional[Project]

            edges: List[ProjectEdge]

        projects: ProjectConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client) -> ProjectsQueryData.ProjectConnection:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectsQueryData.from_dict(response_text)
        return res.projects

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client) -> ProjectsQueryData.ProjectConnection:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectsQueryData.from_dict(response_text)
        return res.projects
