#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.formula_filter_input import FormulaFilterInput
from ..input.formula_order import FormulaOrder


# fmt: off
QUERY: List[str] = ["""
query formulas(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: FormulaOrder
$filterBy: [FormulaFilterInput!]
){
formulas(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
id
textFormula
status
networkTypeFk{id}
kpiFk{id}
techFk{id}

}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class formulas:
    @dataclass(frozen=True)
    class formulasData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class FormulaConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class FormulaEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Formula(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class NetworkType(DataClassJsonMixin):
                        id: str

                    @dataclass(frozen=True)
                    class Kpi(DataClassJsonMixin):
                        id: str

                    @dataclass(frozen=True)
                    class Tech(DataClassJsonMixin):
                        id: str

                    id: str
                    textFormula: str
                    status: bool
                    networkTypeFk: NetworkType
                    kpiFk: Kpi
                    techFk: Tech

                node: Optional[Formula]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[FormulaEdge]
            pageInfo: PageInfo

        formulas: FormulaConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[FormulaOrder] = None, filterBy: List[FormulaFilterInput] = []) -> formulasData.FormulaConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.formulasData.from_dict(response_text)
        return res.formulas

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[FormulaOrder] = None, filterBy: List[FormulaFilterInput] = []) -> formulasData.FormulaConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.formulasData.from_dict(response_text)
        return res.formulas
