#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.event_severity_filter_input import EventSeverityFilterInput
from ..input.event_severity_order import EventSeverityOrder


# fmt: off
QUERY: List[str] = ["""
query eventSeverities(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: EventSeverityOrder
$filterBy: [EventSeverityFilterInput!]
){
eventSeverities(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
id
name

}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class eventSeverities:
    @dataclass(frozen=True)
    class eventSeveritiesData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class EventSeverityConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class EventSeverityEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class EventSeverity(DataClassJsonMixin):
                    id: str
                    name: str

                node: Optional[EventSeverity]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[EventSeverityEdge]
            pageInfo: PageInfo

        eventSeverities: EventSeverityConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[EventSeverityOrder] = None, filterBy: List[EventSeverityFilterInput] = []) -> eventSeveritiesData.EventSeverityConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.eventSeveritiesData.from_dict(response_text)
        return res.eventSeverities

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[EventSeverityOrder] = None, filterBy: List[EventSeverityFilterInput] = []) -> eventSeveritiesData.EventSeverityConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.eventSeveritiesData.from_dict(response_text)
        return res.eventSeverities
