"""
    NLP Sandbox Data Node API

    # Overview  The NLP Sandbox Data Node is a repository of data used to benchmark NLP Tools like the NLP Sandbox Date Annotator and Person Name Annotator.  The resources that can be stored in this Data Node and the operations supported are listed below:  - Create and manage datasets - Create and manage FHIR stores   - Store and retrieve FHIR patient profiles   - Store and retrieve clinical   notes - Create and manage annotation stores   - Store and retrieve text annotations   # noqa: E501

    The version of the OpenAPI document: 1.0.2
    Contact: thomas.schaffter@sagebionetworks.org
    Generated by: https://openapi-generator.tech
"""


import sys
import unittest

import nlpsandbox
from nlpsandbox.model.annotation import Annotation
from nlpsandbox.model.annotation_name import AnnotationName
from nlpsandbox.model.annotation_source import AnnotationSource
from nlpsandbox.model.resource_source import ResourceSource
from nlpsandbox.model.text_date_annotation import TextDateAnnotation
from nlpsandbox.model.page_limit import PageLimit
from nlpsandbox.model.page_offset import PageOffset
from nlpsandbox.model.response_page_metadata import ResponsePageMetadata
from nlpsandbox.model.response_page_metadata_links import ResponsePageMetadataLinks
globals()['Annotation'] = Annotation
globals()['PageLimit'] = PageLimit
globals()['PageOffset'] = PageOffset
globals()['ResponsePageMetadata'] = ResponsePageMetadata
globals()['ResponsePageMetadataLinks'] = ResponsePageMetadataLinks
from nlpsandbox.model.page_of_annotations import PageOfAnnotations


class TestPageOfAnnotations(unittest.TestCase):
    """PageOfAnnotations unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testPageOfAnnotations(self):
        """Test PageOfAnnotations"""
        # FIXME: construct object with mandatory attributes with example values
        # model = PageOfAnnotations()  # noqa: E501
        model = Annotation(
            name=AnnotationName("name"),
            annotation_source=AnnotationSource(resource_source=ResourceSource(name="foo")),
            text_date_annotations=[
                TextDateAnnotation(start=1, length=32, text='foo', confidence=95.5)
            ]
        )
        PageOfAnnotations(
            offset=PageOffset(10),
            limit=PageLimit(10),
            links=ResponsePageMetadataLinks(next="next"),
            total_results=30,
            annotations=[model]
        )



if __name__ == '__main__':
    unittest.main()
