"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const core_1 = require("@aws-cdk/core");
const param = require("./");
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const p = new param.Provider(stack, 'ParameterProvider', {
            latest: false,
        });
        const fooVersion = p.get('Foo').getAttString('Version');
        const barVersion = p.get('Bar').getAttString('Version');
        new core_1.CfnOutput(stack, 'FooVersion', { value: fooVersion });
        new core_1.CfnOutput(stack, 'BarVersion', { value: barVersion });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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