import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface ProviderProps {
    /**
     * always get the latest parameter.
     *
     * @default true
     * @stability stable
     */
    readonly latest?: boolean;
}
/**
 * Parameter Provider.
 *
 * @stability stable
 */
export declare class Provider extends cdk.Construct {
    private provider;
    private handler;
    private latest;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: ProviderProps);
    /**
     * return the parameter resource.
     *
     * @stability stable
     */
    get(name: string): cdk.CustomResource;
}
