"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * (experimental) The policy for the receipt filter.
 *
 * @experimental
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * (experimental) A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @experimental
 */
class ReceiptFilter extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * (experimental) A white list receipt filter.
 *
 * @experimental
 */
class WhiteListReceiptFilter extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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