# Generated by Django 4.0.8 on 2023-01-21 09:00

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("netbox_acls", "0001_initial"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="accesslist",
            options={
                "ordering": ["assigned_object_type", "assigned_object_id", "name"],
                "verbose_name": "Access List",
                "verbose_name_plural": "Access Lists",
            },
        ),
        migrations.AlterModelOptions(
            name="aclextendedrule",
            options={
                "ordering": ["access_list", "index"],
                "verbose_name": "ACL Extended Rule",
                "verbose_name_plural": "ACL Extended Rules",
            },
        ),
        migrations.AlterModelOptions(
            name="aclinterfaceassignment",
            options={
                "ordering": [
                    "assigned_object_type",
                    "assigned_object_id",
                    "access_list",
                    "direction",
                ],
                "verbose_name": "ACL Interface Assignment",
                "verbose_name_plural": "ACL Interface Assignments",
            },
        ),
        migrations.AlterModelOptions(
            name="aclstandardrule",
            options={
                "ordering": ["access_list", "index"],
                "verbose_name": "ACL Standard Rule",
                "verbose_name_plural": "ACL Standard Rules",
            },
        ),
        migrations.AlterField(
            model_name="accesslist",
            name="assigned_object_id",
            field=models.PositiveBigIntegerField(),
        ),
        migrations.AlterField(
            model_name="accesslist",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(("app_label", "dcim"), ("model", "virtualchassis")),
                        models.Q(
                            ("app_label", "virtualization"),
                            ("model", "virtualmachine"),
                        ),
                        _connector="OR",
                    ),
                ),
                on_delete=django.db.models.deletion.PROTECT,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="accesslist",
            name="name",
            field=models.CharField(
                max_length=500,
                validators=[
                    django.core.validators.RegexValidator(
                        "^[0-9a-zA-Z,-,_]*$",
                        "Only alphanumeric, hyphens, and underscores characters are allowed.",
                    ),
                ],
            ),
        ),
        migrations.AlterField(
            model_name="accesslist",
            name="type",
            field=models.CharField(max_length=30),
        ),
        migrations.AlterField(
            model_name="aclextendedrule",
            name="access_list",
            field=models.ForeignKey(
                limit_choices_to={"type": "extended"},
                on_delete=django.db.models.deletion.CASCADE,
                related_name="aclextendedrules",
                to="netbox_acls.accesslist",
            ),
        ),
        migrations.AlterField(
            model_name="aclextendedrule",
            name="remark",
            field=models.CharField(blank=True, default="", max_length=500),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="aclinterfaceassignment",
            name="access_list",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="netbox_acls.accesslist",
            ),
        ),
        migrations.AlterField(
            model_name="aclinterfaceassignment",
            name="assigned_object_id",
            field=models.PositiveBigIntegerField(),
        ),
        migrations.AlterField(
            model_name="aclinterfaceassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "interface")),
                        models.Q(
                            ("app_label", "virtualization"),
                            ("model", "vminterface"),
                        ),
                        _connector="OR",
                    ),
                ),
                on_delete=django.db.models.deletion.PROTECT,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="aclinterfaceassignment",
            name="direction",
            field=models.CharField(max_length=30),
        ),
        migrations.AlterField(
            model_name="aclstandardrule",
            name="access_list",
            field=models.ForeignKey(
                limit_choices_to={"type": "standard"},
                on_delete=django.db.models.deletion.CASCADE,
                related_name="aclstandardrules",
                to="netbox_acls.accesslist",
            ),
        ),
        migrations.AlterField(
            model_name="aclstandardrule",
            name="remark",
            field=models.CharField(blank=True, default="", max_length=500),
            preserve_default=False,
        ),
    ]
