# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6282, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class EpisodeFinish(msrest.serialization.Model):
    """EpisodeFinish event signalling current episode is finished.

    :param reason: Reason for episodeFinish. Possible values include: "Invalid", "Unspecified",
     "LessonChanged", "Terminal", "Interrupted".
    :type reason: str or ~microsoft_bonsai_api.simulator.generated.models.EpisodeFinishReason
    """

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EpisodeFinish, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)


class EpisodeStart(msrest.serialization.Model):
    """EpisodeStart event. It's sent when a new episode need to be started.

    :param config: Initial configuration of simulation for starting an episode.
    :type config: object
    """

    _attribute_map = {
        'config': {'key': 'config', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EpisodeStart, self).__init__(**kwargs)
        self.config = kwargs.get('config', None)


class EpisodeStep(msrest.serialization.Model):
    """EpisodeStep event for stepping inthe simulation. this is sent when there is an ongoing active episode.

    :param action: action decided by RL agent.null use this action to advance from current state of
     simulator.
    :type action: object
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EpisodeStep, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)


class Event(msrest.serialization.Model):
    """RL action returned by bonsai platform when it got new state from simulator session.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of Event as response to advance method. Possible values include:
     "Unspecified", "EpisodeStart", "EpisodeStep", "EpisodeFinish", "Idle", "Unregister".
    :type type: str or ~microsoft_bonsai_api.simulator.generated.models.EventType
    :param session_id: Required. unique session id.
    :type session_id: str
    :param sequence_id: Required. Always startes with 1, and Bonsai platform increment it at each
     Step event in advance operation.static
     Always just return the sequenceId returned by previous advance operation response.
    :type sequence_id: int
    :param episode_start: EpisodeStart event. It's sent when a new episode need to be started.
    :type episode_start: ~microsoft_bonsai_api.simulator.generated.models.EpisodeStart
    :param episode_step: EpisodeStep event for stepping inthe simulation. this is sent when there
     is an ongoing active episode.
    :type episode_step: ~microsoft_bonsai_api.simulator.generated.models.EpisodeStep
    :param episode_finish: EpisodeFinish event signalling current episode is finished.
    :type episode_finish: ~microsoft_bonsai_api.simulator.generated.models.EpisodeFinish
    :param idle: Idle Event.null It means, that no RL action was yet available for this session.
    :type idle: ~microsoft_bonsai_api.simulator.generated.models.Idle
    :param unregister: Event asking to unregister/delete simulatorSession.
     You can create a new session, if you want to continue training with this simulator.
    :type unregister: ~microsoft_bonsai_api.simulator.generated.models.Unregister
    """

    _validation = {
        'type': {'required': True},
        'session_id': {'required': True},
        'sequence_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'sequence_id': {'key': 'sequenceId', 'type': 'int'},
        'episode_start': {'key': 'episodeStart', 'type': 'EpisodeStart'},
        'episode_step': {'key': 'episodeStep', 'type': 'EpisodeStep'},
        'episode_finish': {'key': 'episodeFinish', 'type': 'EpisodeFinish'},
        'idle': {'key': 'idle', 'type': 'Idle'},
        'unregister': {'key': 'unregister', 'type': 'Unregister'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.session_id = kwargs['session_id']
        self.sequence_id = kwargs['sequence_id']
        self.episode_start = kwargs.get('episode_start', None)
        self.episode_step = kwargs.get('episode_step', None)
        self.episode_finish = kwargs.get('episode_finish', None)
        self.idle = kwargs.get('idle', None)
        self.unregister = kwargs.get('unregister', None)


class Idle(msrest.serialization.Model):
    """Idle Event.null It means, that no RL action was yet available for this session.

    :param callback_time: callback time in seconds. this mean,s you should wait for this much time
     before sending a new advance request.
    :type callback_time: float
    """

    _attribute_map = {
        'callback_time': {'key': 'callbackTime', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Idle, self).__init__(**kwargs)
        self.callback_time = kwargs.get('callback_time', None)


class ProblemDetails(msrest.serialization.Model):
    """ProblemDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :param title:
    :type title: str
    :param status:
    :type status: int
    :param detail:
    :type detail: str
    :param instance:
    :type instance: str
    :ivar extensions: Dictionary of :code:`<any>`.
    :vartype extensions: dict[str, object]
    """

    _validation = {
        'extensions': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'status': {'key': 'status', 'type': 'int'},
        'detail': {'key': 'detail', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProblemDetails, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.title = kwargs.get('title', None)
        self.status = kwargs.get('status', None)
        self.detail = kwargs.get('detail', None)
        self.instance = kwargs.get('instance', None)
        self.extensions = None


class Purpose(msrest.serialization.Model):
    """Purpose.

    :param action:  Possible values include: "Inactive", "Debug", "Train", "Assess".
    :type action: str or ~microsoft_bonsai_api.simulator.generated.models.PurposeTypesAction
    :param target:
    :type target: ~microsoft_bonsai_api.simulator.generated.models.PurposeTarget
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'PurposeTarget'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Purpose, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.target = kwargs.get('target', None)


class PurposeTarget(msrest.serialization.Model):
    """PurposeTarget.

    :param workspace_name:
    :type workspace_name: str
    :param brain_name:
    :type brain_name: str
    :param brain_version:
    :type brain_version: int
    :param concept_name:
    :type concept_name: str
    """

    _attribute_map = {
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'brain_name': {'key': 'brainName', 'type': 'str'},
        'brain_version': {'key': 'brainVersion', 'type': 'int'},
        'concept_name': {'key': 'conceptName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurposeTarget, self).__init__(**kwargs)
        self.workspace_name = kwargs.get('workspace_name', None)
        self.brain_name = kwargs.get('brain_name', None)
        self.brain_version = kwargs.get('brain_version', None)
        self.concept_name = kwargs.get('concept_name', None)


class SimulatorContext(msrest.serialization.Model):
    """SimulatorContext.

    :param deployment_mode:  Possible values include: "Unspecified", "Hosted", "Testing".
    :type deployment_mode: str or
     ~microsoft_bonsai_api.simulator.generated.models.SimulatorContextTypesDeploymentMode
    :param deployment_details:
    :type deployment_details: str
    :param simulator_client_id:
    :type simulator_client_id: str
    :param collection:
    :type collection: str
    :param package:
    :type package: str
    :param purpose:
    :type purpose: ~microsoft_bonsai_api.simulator.generated.models.Purpose
    """

    _attribute_map = {
        'deployment_mode': {'key': 'deploymentMode', 'type': 'str'},
        'deployment_details': {'key': 'deploymentDetails', 'type': 'str'},
        'simulator_client_id': {'key': 'simulatorClientId', 'type': 'str'},
        'collection': {'key': 'collection', 'type': 'str'},
        'package': {'key': 'package', 'type': 'str'},
        'purpose': {'key': 'purpose', 'type': 'Purpose'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorContext, self).__init__(**kwargs)
        self.deployment_mode = kwargs.get('deployment_mode', None)
        self.deployment_details = kwargs.get('deployment_details', None)
        self.simulator_client_id = kwargs.get('simulator_client_id', None)
        self.collection = kwargs.get('collection', None)
        self.package = kwargs.get('package', None)
        self.purpose = kwargs.get('purpose', None)


class SimulatorInterface(msrest.serialization.Model):
    """It contains all the registration/creation time properties of a simulator session.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the simulator session.
    :type name: str
    :param timeout: This is the max time in seconds, within which simulator need to send advance
     request, else it will be timed out and unregistered from Bonsai platform.
     Set it to (SimulatorComputeTime + RTT network latency + few seconds)
     Default is 60s.
    :type timeout: float
    :param capabilities: Additional Capabilities for the session.
    :type capabilities: object
    :param simulator_context: Opaque string to the sim authors. It's used to connect simulator
     sessions to right brain.false
     For hosted sims, we automatically take care of setting the right environment variable for
     this.
     For Local sims, set it to empty string, and use Bonsai CLI's, ``bonsai connect`` command.
    :type simulator_context: str
    :param description: Schema descriptions of the simulator. Contains State, Action and Config
     schemas.
    :type description: object
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'float'},
        'capabilities': {'key': 'capabilities', 'type': 'object'},
        'simulator_context': {'key': 'simulatorContext', 'type': 'str'},
        'description': {'key': 'description', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorInterface, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.timeout = kwargs.get('timeout', None)
        self.capabilities = kwargs.get('capabilities', None)
        self.simulator_context = kwargs.get('simulator_context', None)
        self.description = kwargs.get('description', None)


class SimulatorSessionMilestone(msrest.serialization.Model):
    """SimulatorSession progress milestone.

    :param first_time: First time, this session made the specified progress.
    :type first_time: ~datetime.datetime
    """

    _attribute_map = {
        'first_time': {'key': 'firstTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorSessionMilestone, self).__init__(**kwargs)
        self.first_time = kwargs.get('first_time', None)


class SimulatorSessionProgress(msrest.serialization.Model):
    """SimulatorSession progress related to train an actual brain.

    :param attached: SimulatorSession progress milestone.
    :type attached: ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionMilestone
    :param iterated: SimulatorSession progress milestone.
    :type iterated: ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionMilestone
    """

    _attribute_map = {
        'attached': {'key': 'attached', 'type': 'SimulatorSessionMilestone'},
        'iterated': {'key': 'iterated', 'type': 'SimulatorSessionMilestone'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorSessionProgress, self).__init__(**kwargs)
        self.attached = kwargs.get('attached', None)
        self.iterated = kwargs.get('iterated', None)


class SimulatorSessionResponse(msrest.serialization.Model):
    """SimulatorSession model, having details of one active simulator session.

    All required parameters must be populated in order to send to Azure.

    :param session_id: Required. Unique sessionId for this session.
    :type session_id: str
    :param session_status:  Possible values include: "Deregistered", "Attachable", "Attached",
     "Detaching", "Rejected".
    :type session_status: str or
     ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionTypesStatus
    :param session_progress: SimulatorSession progress related to train an actual brain.
    :type session_progress:
     ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionProgress
    :param interface: It contains all the registration/creation time properties of a simulator
     session.
    :type interface: ~microsoft_bonsai_api.simulator.generated.models.SimulatorInterface
    :param simulator_context:
    :type simulator_context: ~microsoft_bonsai_api.simulator.generated.models.SimulatorContext
    :param registration_time: Required. Time, when this session was registered with Bonsai
     platform.
    :type registration_time: ~datetime.datetime
    :param last_seen_time: Required. Last time, when any request for this session was seen.
    :type last_seen_time: ~datetime.datetime
    :param iteration_rate: Current IterationRate, 1 state-action loop is roughly maps to 1
     iteration.
    :type iteration_rate: float
    :param details: Additional Details for this session provided by bonsai platform.
    :type details: str
    """

    _validation = {
        'session_id': {'required': True},
        'registration_time': {'required': True},
        'last_seen_time': {'required': True},
    }

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'session_status': {'key': 'sessionStatus', 'type': 'str'},
        'session_progress': {'key': 'sessionProgress', 'type': 'SimulatorSessionProgress'},
        'interface': {'key': 'interface', 'type': 'SimulatorInterface'},
        'simulator_context': {'key': 'simulatorContext', 'type': 'SimulatorContext'},
        'registration_time': {'key': 'registrationTime', 'type': 'iso-8601'},
        'last_seen_time': {'key': 'lastSeenTime', 'type': 'iso-8601'},
        'iteration_rate': {'key': 'iterationRate', 'type': 'float'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorSessionResponse, self).__init__(**kwargs)
        self.session_id = kwargs['session_id']
        self.session_status = kwargs.get('session_status', None)
        self.session_progress = kwargs.get('session_progress', None)
        self.interface = kwargs.get('interface', None)
        self.simulator_context = kwargs.get('simulator_context', None)
        self.registration_time = kwargs['registration_time']
        self.last_seen_time = kwargs['last_seen_time']
        self.iteration_rate = kwargs.get('iteration_rate', None)
        self.details = kwargs.get('details', None)


class SimulatorSessionSummary(msrest.serialization.Model):
    """SimulatorSessionSummary.

    :param session_id:
    :type session_id: str
    :param session_status:  Possible values include: "Deregistered", "Attachable", "Attached",
     "Detaching", "Rejected".
    :type session_status: str or
     ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionTypesStatus
    :param simulator_name:
    :type simulator_name: str
    :param simulator_context:
    :type simulator_context: ~microsoft_bonsai_api.simulator.generated.models.SimulatorContext
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'session_status': {'key': 'sessionStatus', 'type': 'str'},
        'simulator_name': {'key': 'simulatorName', 'type': 'str'},
        'simulator_context': {'key': 'simulatorContext', 'type': 'SimulatorContext'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorSessionSummary, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.session_status = kwargs.get('session_status', None)
        self.simulator_name = kwargs.get('simulator_name', None)
        self.simulator_context = kwargs.get('simulator_context', None)


class SimulatorState(msrest.serialization.Model):
    """It contains simulator state information needed by bonsai platform in response of an action.

    All required parameters must be populated in order to send to Azure.

    :param sequence_id: Required. Always startes with 1, and Bonsai platform increment it at each
     Step event in advance operation.static
     Always just return the sequenceId returned by previous advance operation response.
    :type sequence_id: int
    :param state: State of your simulator model.
    :type state: object
    :param halted: Optional halt parameter to indicate, simulator wants to halt.
     Implicitly false when not present.
    :type halted: bool
    :param error: No error if not defined or empty.
    :type error: str
    """

    _validation = {
        'sequence_id': {'required': True},
    }

    _attribute_map = {
        'sequence_id': {'key': 'sequenceId', 'type': 'int'},
        'state': {'key': 'state', 'type': 'object'},
        'halted': {'key': 'halted', 'type': 'bool'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SimulatorState, self).__init__(**kwargs)
        self.sequence_id = kwargs['sequence_id']
        self.state = kwargs.get('state', None)
        self.halted = kwargs.get('halted', None)
        self.error = kwargs.get('error', None)


class Unregister(msrest.serialization.Model):
    """Event asking to unregister/delete simulatorSession.
You can create a new session, if you want to continue training with this simulator.

    :param reason: Reason for unregister event. Possible values include: "Unspecified", "Finished",
     "Error", "NotFound".
    :type reason: str or ~microsoft_bonsai_api.simulator.generated.models.UnregisterReason
    :param details: Detail message for unregister event.
    :type details: str
    """

    _attribute_map = {
        'reason': {'key': 'reason', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Unregister, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.details = kwargs.get('details', None)
