"""create_weather_sensor_type_and_weather_sensor_and_weather_tables

Revision ID: 4b6cebbdf473
Revises: 11b735abebe7
Create Date: 2018-06-07 12:13:44.504308

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "4b6cebbdf473"
down_revision = "11b735abebe7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "weather_sensor_type",
        sa.Column("name", sa.String(length=80), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    op.create_table(
        "weather_sensor",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=80), nullable=True),
        sa.Column("weather_sensor_type_name", sa.String(length=80), nullable=False),
        sa.ForeignKeyConstraint(
            ["weather_sensor_type_name"], ["weather_sensor_type.name"]
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "weather",
        sa.Column("sensor_id", sa.Integer(), nullable=False),
        sa.Column("datetime", sa.DateTime(timezone=True), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.ForeignKeyConstraint(["sensor_id"], ["weather_sensor.id"]),
        sa.PrimaryKeyConstraint("sensor_id", "datetime"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("weather")
    op.drop_table("weather_sensor")
    op.drop_table("weather_sensor_type")
    # ### end Alembic commands ###
