export declare const PathConstants: {
    DotAWSDirName: string;
    AWSCredentials: string;
    AWSConfig: string;
    DeploymentSecretsFileName: string;
    AmplifyAdminDirName: string;
    AmplifyDirName: string;
    DotAmplifyDirName: string;
    DotConfigDirName: string;
    BackendDirName: string;
    CurrentCloudBackendDirName: string;
    HooksDirName: string;
    AmplifyAdminConfigFileName: string;
    AmplifyRcFileName: string;
    GitIgnoreFileName: string;
    ProjectConfigFileName: string;
    AmplifyMetaFileName: string;
    TagsFileName: string;
    ParametersJsonFileName: string;
    ReadMeFileName: string;
    HooksConfigFileName: string;
    HooksShellSampleFileName: string;
    HooksJsSampleFileName: string;
    HooksReadmeFileName: string;
    LocalEnvFileName: string;
    LocalAWSInfoFileName: string;
    TeamProviderInfoFileName: string;
    BackendConfigFileName: string;
    CLIJSONFileName: string;
    CLIJSONFileNameGlob: string;
    CLIJsonWithEnvironmentFileName: (env: string) => string;
    CfnFileName: (resourceName: string) => string;
};
export declare class PathManager {
    private readonly homeDotAmplifyDirPath;
    constructor();
    getAmplifyPackageLibDirPath: (packageName: string) => string;
    getAmplifyLibRoot: () => string;
    getHomeDotAmplifyDirPath: () => string;
    getAmplifyAdminDirPath: () => string;
    getAmplifyAdminConfigFilePath: () => string;
    getAmplifyDirPath: (projectPath?: string | undefined) => string;
    getDotConfigDirPath: (projectPath?: string | undefined) => string;
    getBackendDirPath: (projectPath?: string | undefined) => string;
    getCurrentCloudBackendDirPath: (projectPath?: string | undefined) => string;
    getCurrentResourceParametersJsonPath: (projectPath: string | undefined, categoryName: string, resourceName: string) => string;
    getCurrentCfnTemplatePath: (projectPath: string | undefined, categoryName: string, resourceName: string) => string;
    getAmplifyRcFilePath: (projectPath?: string | undefined) => string;
    getGitIgnoreFilePath: (projectPath?: string | undefined) => string;
    getTeamProviderInfoFilePath: (projectPath?: string | undefined) => string;
    getProjectConfigFilePath: (projectPath?: string | undefined) => string;
    getLocalEnvFilePath: (projectPath?: string | undefined) => string;
    getLocalAWSInfoFilePath: (projectPath?: string | undefined) => string;
    getAmplifyMetaFilePath: (projectPath?: string | undefined) => string;
    getBackendConfigFilePath: (projectPath?: string | undefined) => string;
    getTagFilePath: (projectPath?: string | undefined) => string;
    getCurrentTagFilePath: (projectPath?: string | undefined) => string;
    getResourceDirectoryPath: (projectPath: string | undefined, category: string, resourceName: string) => string;
    getResourceParametersFilePath: (projectPath: string | undefined, category: string, resourceName: string) => string;
    getResourceCfnTemplatePath: (projectPath: string | undefined, category: string, resourceName: string) => string;
    getReadMeFilePath: (projectPath?: string | undefined) => string;
    getCurrentAmplifyMetaFilePath: (projectPath?: string | undefined) => string;
    getCurrentBackendConfigFilePath: (projectPath?: string | undefined) => string;
    getDotAWSDirPath: () => string;
    getAWSCredentialsFilePath: () => string;
    getAWSConfigFilePath: () => string;
    getCLIJSONFilePath: (projectPath: string, env?: string | undefined) => string;
    getDotAWSAmplifyDirPath: () => string;
    getDeploymentSecrets: () => string;
    getHooksDirPath: (projectPath?: string | undefined) => string;
    getHooksConfigFilePath: (projectPath?: string | undefined) => string;
    private constructPath;
    private validateProjectPath;
    findProjectRoot: () => string | undefined;
}
export declare const pathManager: PathManager;
//# sourceMappingURL=pathManager.d.ts.map