"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLogger = void 0;
const amplify_cli_logger_1 = require("amplify-cli-logger");
const getLogger = (moduleName, fileName) => {
    return {
        info: (message, args = {}) => {
            amplify_cli_logger_1.logger.logInfo({ message: `${moduleName}.${fileName}.${message}(${amplify_cli_logger_1.Redactor(JSON.stringify(args))}` });
        },
        error: (message, error) => {
            amplify_cli_logger_1.logger.logError({ message: `${moduleName}.${fileName}.${message}`, error });
        },
    };
};
exports.getLogger = getLogger;
//# sourceMappingURL=index.js.map