import functools
import typing

__all__ = [
    'cvm_codes'
]

@functools.lru_cache
def _cvm_codes() -> typing.List[str]:
    return [
        '10456', # ALPARGATAS S.A.
        '10472', # SARAIVA LIVREIROS S.A.
        '10596', # SERGEN SERVS GERAIS DE ENG SA
        '10880', # SONDOTECNICA ENGENHARIA SOLOS S.A.
        '10960', # SPRINGER S.A.
        '11070', # WLM PART. E COMÉRCIO DE MÁQUINAS E VEÍCULOS S.A.
        '11207', # TECNOSOLO ENGENHARIA S.A.
        '11223', # TEKA-TECELAGEM KUEHNRICH S.A.
        '11231', # TEKNO S.A. - INDUSTRIA E COMERCIO
        '11258', # TELEC BRASILEIRAS S.A. TELEBRAS
        '11312', # OI S.A.
        '11320', # TELEMAR NORTE LESTE SA
        '11398', # TRONOX PIGMENTOS DO BRASIL S.A.
        '11592', # UNIPAR CARBOCLORO S.A.
        '11762', # VULCABRAS S.A.
        '11800', # WEMBLEY SOCIEDADE ANÔNIMA
        '11932', # IOCHPE MAXION S.A.
        '11975', # AZEVEDO E TRAVASSOS S.A.
        '11991', # WETZEL S.A. 
        '12190', # BOMBRIL S.A.
        '12220', # USINA COSTA PINTO SA ACUC ALC
        '12262', # JPSP INVESTIMENTOS E PARTICIPAÇÕES S/A
        '12319', # BLUE TECH SOLUTIONS EQI S.A.
        '12530', # ITAUTEC S.A.
        '12572', # RECRUSUL S.A.
        '12653', # KLABIN S.A.
        '12696', # SANSUY S.A. INDUSTRIA DE PLASTICOS
        '12793', # FIBRIA CELULOSE S.A.
        '12823', # SIDERURGICA J. L. ALIPERTI S.A.
        '12858', # DIGITEL SA INDUSTRIA ELETRONICA
        '12866', # INDÚSTRIA VEROLME S.A. - IVESA
        '13030', # CONSTRUTORA SULTEPA S.A.
        '13285', # JOSAPAR-JOAQUIM OLIVEIRA S.A. - PARTICIP
        '13366', # HAGA S.A. INDUSTRIA E COMERCIO
        '13412', # ÉVORA SA
        '13439', # METALURGICA RIOSULENSE S.A.
        '13471', # PLASCAR PARTICIPACOES INDUSTRIAIS S.A.
        '13765', # MINUPAR PARTICIPACOES S.A.
        '13773', # PBG S/A
        '13781', # SAO CARLOS EMPREEND E PARTICIPACOES S.A.
        '13986', # SUZANO S.A.
        '140',   # YARA BRASIL FERTILIZANTES
        '14010', # PREDILETO ALIMENTOS SA
        '14028', # VALE FERTILIZANTES S.A.
        '14109', # RANDON S.A. IMPLEMENTOS E PARTICIPACOES
        '14133', # TEC TOY S.A.
        '14311', # CIA PARANAENSE DE ENERGIA - COPEL
        '14320', # USINAS SID DE MINAS GERAIS S.A.-USIMINAS
        '14346', # WHIRLPOOL S.A.
        '14443', # CIA SANEAMENTO BASICO EST SAO PAULO
        '14451', # COMPANHIA ENERGÉTICA DE BRASÍLIA - CEB
        '14460', # CYRELA BRAZIL REALTY S.A.EMPREEND E PART
        '14540', # VBC ENERGIA SA
        '14559', # M&G POLIÉSTER SA
        '14621', # NET SERVIÇOS DE COMUNICAÇÃO S.A.
        '14664', # SCHULZ S.A.
        '14761', # CIA HERING
        '14796', # FORPART S.A.
        '14826', # CIA BRASILEIRA DE DISTRIBUICAO
        '14931', # DIXIE TOGA SA
        '15083', # KOSMOS COMÉRCIO DE VESTUÁRIO S/A
        '15091', # LITEL PARTICIPACOES S.A.
        '1520',  # BARDELLA S.A. INDUSTRIAS MECANICAS 
        '15253', # ENERGISA S.A.
        '15300', # RUMO MALHA NORTE S.A.
        '15369', # FERROVIA CENTRO-ATLANTICA S.A.
        '15423', # ATOM EMPREENDIMENTOS E PARTICIPAÇÕES S.A.
        '15458', # EMBPAR PARTICIPAÇÕES S/A
        '15539', # NEOENERGIA S.A.
        '15610', # CECRISA REVESTIMENTOS CERAMICOS SA
        '1562',  # BAUMER S.A.
        '15652', # COMERCIAL QUINTELLA COM EXP SA EM LIQUIDAÇÃO
        '1597',  # PARTICIPAÇÕES INDUST. DO NORDESTE S.A.
        '16101', # GAFISA S.A.
        '16225', # VALETRON SA
        '16233', # BELAPART SA
        '16292', # BRF S.A.
        '16306', # ROSSI RESIDENCIAL S.A.
        '16330', # 521 PARTICIPACOES S.A.
        '16390', # TAM S.A.
        '16438', # SUL 116 PARTICIPACOES S.A.
        '16497', # EMPRESA NAC COM REDITO PART S.A.ENCORPAR
        '16624', # UPTICK PARTICIPACOES S.A.
        '16632', # DEXXOS PARTICIPAÇÕES S.A.
        '16659', # PORTO SEGURO S.A.
        '16675', # CEL PARTICIPAÇÕES S.A.
        '16730', # INEPAR ENERGIA SA
        '16748', # CIA RIOGRANDENSE DE SANEAMENTO
        '1694',  # BICICLETAS MONARK S.A.
        '16950', # DALETH PARTICIPAÇÕES SA
        '16993', # EMAE - EMPRESA METROP.AGUAS ENERGIA S.A.
        '17329', # ENGIE BRASIL ENERGIA S.A.
        '17337', # RET PARTICIPACOES S.A.
        '17361', # ZAIN PARTICIPACOES S.A.
        '17388', # FUTURETEL S.A.
        '17418', # TELINVEST S.A.
        '17442', # LF TEL SA
        '17450', # RUMO S.A.
        '17493', # CAPITALPART PARTICIPAÇÕES SA
        '17540', # NEWTEL PARTICIPACOES S.A.
        '17558', # INNCORP S.A.
        '17604', # TELE NORTE CELULAR PARTICIPAÇÕES SA
        '17639', # TIM PARTICIPACOES S.A.
        '17647', # EMBRATEL PARTICIPAÇÕES SA
        '17655', # TELE NORTE LESTE PARTICIPAÇÕES SA
        '17671', # TELEFÔNICA BRASIL S.A
        '17710', # VIVO PARTICIPAÇÕES SA
        '17779', # MAORI SA
        '17892', # SANTOS BRASIL PARTICIPACOES S.A.
        '17914', # MMX MINERACAO E METALICOS S.A.
        '17922', # BRAZILIAN FINANCE E REAL ESTATE S.A.
        '17930', # RUMO MALHA PAULISTA S.A.
        '17973', # COGNA EDUCAÇÃO S.A.
        '18112', # COMPANHIA DE BEBIDAS DAS AMÉRICAS-AMBEV
        '18287', # VIRGO II COMPANHIA DE SECURITIZACAO
        '18350', # AES TIETE SA
        '18368', # RIO PARANAPANEMA ENERGIA S.A.
        '18376', # CTEEP - CIA TRANSMISSÃO ENERGIA ELÉTRICA PAULISTA
        '18414', # PADTEC HOLDING S.A.
        '18465', # ULTRAPAR PARTICIPACOES S.A.
        '18635', # PRIVATINVEST PARTICIPAÇÕES SA
        '18651', # ARAUCÁRIA PARTICIPAÇÕES SA
        '18660', # CPFL ENERGIA S.A.
        '18678', # TELEMAR PARTICIPAÇÕES SA
        '18708', # CIA PARTICIPACOES ALIANCA DA BAHIA
        '18716', # CEMIG TELECOMUNICAÇÕES S.A.
        '18724', # BRADESPAR S.A.
        '18775', # INVESTIMENTOS E PARTICIP. EM INFRA S.A. - INVEPAR
        '18821', # CCR S.A.
        '18902', # VICUNHA SIDERURGIA SA
        '18953', # CPFL GERACAO DE ENERGIA S.A.
        '18961', # ANHANGUERA EDUCACIONAL PARTICIPAÇÕES S.A.
        '18970', # AES TIETE ENERGIA SA
        '18988', # VOTORANTIM FINANÇAS SA
        '19046', # BROOKFIELD SÃO PAULO EMPREENDIMENTOS IMOBILIÁRIOS S.A.
        '19062', # ANDRADE GUTIERREZ PARTICIPACOES S.A.
        '19089', # COARI PARTICIPAÇÕES SA
        '19100', # ATMA PARTICIPAÇÕES S.A.
        '19143', # EDITORA ABRIL S/A
        '19216', # CP CIMENTO E PARTICIPAÇÕES S/A
        '19305', # BIOMM S.A.
        '19313', # AES ELPA S.A.
        '19330', # TPI - TRIUNFO PARTICIP. E INVEST. S.A.
        '19402', # GLOBAL BRASIL SA
        '19437', # ANDRADE GUTIERREZ CONCESSOES S.A.
        '19445', # CIA SANEAMENTO DE MINAS GERAIS-COPASA MG
        '19453', # ECORODOVIAS INFRAESTRUTURA E LOGÍSTICA S.A.
        '19550', # NATURA COSMETICOS S.A.
        '19569', # GOL LINHAS AEREAS INTELIGENTES S.A.
        '19615', # GRENDENE S.A.
        '19623', # DIAGNOSTICOS DA AMERICA S.A.
        '19631', # CAMARGO CORREA CIMENTOS SA
        '19658', # POMIFRUTAS S/A EM RECUPERACAO JUDICIAL
        '19739', # LOCALIZA RENT A CAR S.A.
        '19763', # EDP - ENERGIAS DO BRASIL S.A.
        '19771', # ARTERIS S.A.
        '19798', # PARAMOUNT TEXTEIS INDUSTRIA E COMERCIO S/A
        '19801', # BUDDEMEYER S/A
        '19836', # COSAN S.A.
        '19860', # RB CAPITAL SECURITIZADORA S.A.
        '19879', # LIGHT S.A.
        '19887', # UNIVERSO ONLINE SA
        '19909', # BR MALLS PARTICIPACOES S.A.
        '19917', # TEMPO PARTICIPAÇOES S/A
        '19925', # BR PROPERTIES S.A.
        '19933', # ITAUSEG PARTICIPAÇÕES SA
        '19992', # TOTVS S.A.
        '20010', # EQUATORIAL ENERGIA S.A.
        '20028', # VALID SOLUÇÕES S.A.
        '20036', # BRASILAGRO - CIA BRAS DE PROP AGRICOLAS
        '20060', # LUPATECH S.A.
        '20087', # EMBRAER S.A.
        '20125', # ODONTOPREV S.A.
        '20141', # CREMER SA
        '20168', # ÓLEO E GÁS PARTICIPAÇÕES S.A.
        '20184', # CCX CARVÃO DA COLÔMBIA S.A.
        '20214', # AMPLA INVESTIMENTOS E SERVIÇOS S/A
        '20257', # TRANSMISSORA ALIANÇA DE ENERGIA ELÉTRICA S.A.
        '20265', # BROOKFIELD INCORPORAÇÕES S.A.
        '20320', # CEMIG GERACAO E TRANSMISSAO S.A.
        '20338', # M.DIAS BRANCO S.A. IND COM DE ALIMENTOS
        '20346', # PROFARMA DISTRIB PROD FARMACEUTICOS S.A.
        '20354', # TERRA SANTA AGRO S.A.
        '20362', # POSITIVO TECNOLOGIA S.A.
        '20370', # LPS BRASIL - CONSULTORIA DE IMOVEIS S.A.
        '20400', # SAFRA COMPANHIA SECURITIZADORA DE CREDITOS IMOBILIARIOS
        '20419', # ONE PROPERTIES S.A.
        '20435', # TECNISA S.A.
        '20451', # RNI NEGÓCIOS IMOBILIÁRIOS S.A.
        '20478', # PDG REALTY S.A. EMPREEND E PARTICIPACOES
        '20486', # CAMARGO CORREA DESENVOLVIMENTO IMOBILIARIO SA
        '20494', # IGUATEMI EMPRESA DE SHOPPING CENTERS S.A
        '20516', # SAO MARTINHO S.A.
        '20524', # EVEN CONSTRUTORA E INCORPORADORA S.A.
        '20540', # CPFL ENERGIAS RENOVÁVEIS S.A.
        '20575', # JBS S.A.
        '20605', # JHSF PARTICIPACOES S.A.
        '20613', # METALFRIO SOLUTIONS S.A.
        '2062',  # CAFE SOLUVEL BRASILIA SA
        '20621', # FERTILIZANTES HERINGER S.A.
        '20630', # CR2 EMPREENDIMENTOS IMOBILIARIOS S.A.
        '20656', # BEMATECH IND COM EQUIP ELETRONICOS SA
        '20702', # VIVER INCORPORADORA E CONSTRUTORA S.A.
        '20710', # LOG-IN LOGISTICA INTERMODAL S.A.
        '20745', # SLC AGRICOLA S.A.
        '20770', # EZ TEC EMPREEND. E PARTICIPACOES S.A.
        '20788', # MARFRIG GLOBAL FOODS S.A.
        '20800', # TEGMA GESTAO LOGISTICA S.A.
        '20818', # VIRGO COMPANHIA DE SECURITIZAÇÃO
        '20842', # MAGNESITA REFRATARIOS S.A.
        '20850', # ALLIS PARTICIPAÇÕES S.A.
        '20877', # HELBOR EMPREENDIMENTOS S.A.
        '20907', # BHG S.A. - BRAZIL HOSPITALITY GROUP
        '20915', # MRV ENGENHARIA E PARTICIPACOES S.A.
        '20931', # MINERVA S.A.
        '20966', # SPRINGS GLOBAL PARTICIPACOES S.A.
        '20974', # COMPANHIA PROVIDENCIA IND E COMERCIO
        '20982', # MULTIPLAN - EMPREEND IMOBILIARIOS S.A.
        '20990', # AMERICANAS S.A.
        '2100',  # CAMBUCI S.A.
        '21008', # GENERAL SHOPPING E OUTLETS DO BRASIL BRASIL S.A.
        '21016', # YDUQS PARTICIPACOES S.A.
        '21032', # ALGAR TELECOM S/A
        '21040', # SYN PROP & TECH S.A.
        '21067', # MOURA DUBEUX ENGENHARIA S/A
        '21091', # DEXCO S.A.
        '21121', # SUL AMERICA S.A.
        '21130', # TRISUL S.A.
        '21148', # CONSTRUTORA TENDA S.A.
        '21156', # J. MACEDO S.A.
        '21172', # AMIL PARTICIPAÇÕES S/A
        '21180', # BRASIL BROKERS PARTICIPACOES S.A.
        '21202', # VIX LOGÍSTICA S/A
        '21237', # ENEVA S.A
        '21261', # MONTICIANO PARTICIPAÇÕES S/A
        '21300', # ALIANSCE SHOPPING CENTERS S.A.
        '21334', # NUTRIPLANT INDUSTRIA E COMERCIO S.A.
        '21342', # OSX BRASIL S.A.
        '21350', # DIRECIONAL ENGENHARIA S.A.
        '21393', # CIA CELG DE PARTICIPACOES - CELGPAR
        '21415', # BRZ INVESTIMENTOS S/A
        '21431', # HYPERA S.A.
        '21440', # RESTOQUE COMÉRCIO E CONFECÇÕES DE ROUPAS S.A.
        '21482', # PRUMO LOGISTICA SA
        '21490', # ALUPAR INVESTIMENTO S/A
        '21520', # MULTINER S/A
        '21539', # REP REAL ESTATE PARTNERS DESENV IMOB SA
        '21555', # UNIDAS S.A.
        '21563', # BERNA PARTICIPAÇÕES SA
        '21580', # BELMONTE PARTICIPAÇÕES SA
        '21601', # BASEL PARTICIPAÇÕES S/A
        '21610', # B3 S.A. - BRASIL, BOLSA, BALCÃO
        '21636', # RENOVA ENERGIA S.A.
        '21652', # CTX PARTICIPAÇÕES S/A
        '21709', # CIA MINEIRA DE AÇUCAR E ALCOOL PARTICIPAÇÕES
        '21717', # TARPON INVESTIMENTOS S.A.
        '21725', # ADVANCED DIGITAL HEALTH MEDICINA PREVENTIVA S.A.
        '21733', # CIELO S.A.
        '21776', # CENTENNIAL ASSET PARTICIPAÇÕES SUDESTE S/A
        '21792', # CETIP S.A. - BALCÃO ORGANIZADO DE ATIVOS E DERIVATIVOS
        '21806', # AGV HOLDING S/A
        '21865', # BRAZAL BRASIL ALIMENTOS SA
        '21881', # FLEURY S.A.
        '21903', # ECORODOVIAS CONCESSÕES E SERVIÇOS S.A.
        '22012', # MILLS ESTRUTURAS E SERVIÇOS DE ENGENHARIA S.A.
        '22020', # JSL S.A.
        '22047', # METROPOLIS EMPREENDIMENTOS IMOBILIÁRIOS S/A
        '22055', # MARISA LOJAS S.A.
        '22110', # OMEGA ENERGIA RENOVÁVEL S/A
        '22128', # REDENTOR ENERGIA S/A
        '22136', # TEREOS INTERNACIONAL S/A
        '22144', # CONCESSÃO METROVIÁRIA DO RIO DE JANEIRO S.A.
        '22187', # PETRO RIO S.A.
        '22209', # PASCRO PARTICIPAÇÕES S.A.
        '22217', # ALPER CONSULTORIA E CORRETORA DE SEGUROS S.A.
        '22330', # RJ CAPITAL PARTNERS S.A.
        '22349', # AREZZO INDÚSTRIA E COMÉRCIO S.A.
        '22357', # ALIANSCE SONAE SHOPPING CENTERS S.A.
        '22365', # ENAUTA PARTICIPAÇÕES S.A.
        '22373', # ELETROSOM S/A
        '22381', # AUTOMETAL S.A.
        '22438', # INTERNATIONAL MEAL COMPANY HOLDINGS S/A
        '22454', # T4F ENTRETENIMENTO S.A.
        '22470', # MAGAZINE LUIZA S.A.
        '22497', # QUALICORP CONSULTORIA E CORRETORA DE SEGUROS S.A.
        '22500', # BRASIL PHARMA S.A.
        '22519', # TECHNOS S.A.
        '22535', # COPERSUCAR S.A.
        '22551', # SOMOS EDUCAÇÃO S.A.
        '22560', # INBRANDS S.A.
        '22586', # MLOG S.A.
        '22594', # STATKRAFT ENERGIAS RENOVAVEIS S.A.
        '22632', # BELEZA PARTICIPAÇÕES S.A.
        '22667', # NAOMI PARTICIPAÇÕES S.A.
        '22675', # HIDROVIAS DO BRASIL S.A.
        '22691', # CIA LOCAÇÃO DAS AMÉRICAS
        '22772', # VIGOR ALIMENTOS S.A.
        '22780', # UNICASA INDÚSTRIA DE MÓVEIS S.A.
        '22799', # SENIOR SOLUTION S.A.
        '22810', # ELDORADO BRASIL CELULOSE S.A.
        '22829', # CIMENTO TUPI S.A.
        '22845', # BIOSEV S.A.
        '22942', # MGI - MINAS GERAIS PARTICIPAÇÕES S.A.
        '23000', # LIGHT ENERGIA S.A.
        '23035', # LINX S.A.
        '23116', # FINPAR PARTICIPAÇÕES S/A
        '23140', # SMILES S.A.
        '23175', # IGUA SANEAMENTO S.A.
        '23183', # ALTUS SISTEMAS DE AUTOMAÇÃO S.A.
        '23221', # SER EDUCACIONAL S.A.
        '23230', # RAIZEN ENERGIA S.A.
        '23248', # ANIMA HOLDING S.A.
        '23264', # AMBEV S.A.
        '23272', # LOG COMMERCIAL PROPERTIES E PARTICIPAÇÕES
        '23280', # OURO VERDE LOCACAO E SERVICO S.A.
        '23302', # QUALITY SOFTWARE S.A.
        '23310', # CVC BRASIL OPERADORA E AGÊNCIA DE VIAGENS S.A.
        '23396', # AEGEA SANEAMENTO E PARTICIPAÇÕES S.A.
        '23426', # OMEGA GERAÇÃO S.A.
        '23434', # LIBRA TERMINAL RIO S.A.
        '23450', # RUMO LOGÍSTICA OPERADORA MULTIMODAL S.A.
        '23485', # COSAN LOGISTICA S.A.
        '23493', # DOMMO ENERGIA S.A.
        '23507', # OURO FINO SAUDE ANIMAL PARTICIPACOES S.A.
        '23531', # CLARO TELECOM PARTICIPAÇÕES S.A.
        '23574', # INTERNATIONAL MEAL COMPANY ALIMENTACAO S.A.
        '23590', # WIZ SOLUÇÕES E CORRETAGEM DE SEGUROS S.A.
        '23604', # YOU INC INCORPORADORA E PARTICIPAÇÃO S.A
        '23612', # MAESTRO LOCADORA DE VEICULOS S.A.
        '23620', # CBO HOLDING S.A.
        '23710', # BR HOME CENTERS S.A.
        '23728', # PRÁTICA PARTICIPAÇÕES S/A
        '23736', # FORNO DE MINAS ALIMENTOS S.A.
        '23779', # BS&C EMPREENDIMENTOS E PARTICIPAÇÕES S.A.
        '23795', # CAIXA SEGURIDADE PARTICIPAÇÕES S.A.
        '23817', # BRQ SOLUCOES EM INFORMATICA S.A.
        '23825', # MOVIDA PARTICIPACOES SA
        '23868', # CONCEBRA - CONCESSIONARIA DAS RODOVIAS CENTRAIS DO BRASIL
        '23930', # BRASILIANA PARTICIPAÇÕES S/A
        '23957', # SUGOI S.A.
        '23965', # CINESYSTEM S.A.
        '23981', # CTC - CENTRO DE TECNOLOGIA CANAVIEIRA S.A.
        '24058', # CENTRO DE IMAGEM DIAGNOSTICOS S.A.
        '24090', # INSTITUTO HERMES PARDINI S.A.
        '24112', # AZUL S.A.
        '24120', # ARGO ENERGIA EMPREENDIMENTOS E PARTICIPAÇÕES S/A
        '24171', # ATACADÃO S.A.
        '24201', # STARA S.A. - INDÚSTRIA DE IMPLEMENTOS AGRÍCOLAS
        '24228', # CAMIL ALIMENTOS S.A.
        '24236', # PRINER SERVIÇOS INDUSTRIAIS S.A.
        '24252', # SMILES FIDELIDADE S.A.
        '24260', # SMARTFIT ESCOLA DE GINÁSTICA E DANÇA S.A.
        '24279', # INTER CONSTRUTORA E INCORPORADORA S.A.
        '2429',  # IRANI PAPEL E EMBALAGEM S.A.
        '24295', # VIBRA ENERGIA S/A
        '24309', # VENTURE CAPITAL PARTICIPAÇÕES E INVESTIMENTOS S/A
        '24317', # BK BRASIL OPERAÇÃO E ASSESSORIA A RESTAURANTES SA
        '24350', # FLEX GESTÃO DE RELACIONAMENTOS S.A.
        '2437',  # CENTRAIS ELET BRAS S.A. - ELETROBRAS
        '24384', # NOTRE DAME INTERMÉDICA PARTICIPAÇÕES S.A.
        '24392', # HAPVIDA PARTICIPAÇÕES E INVESTIMENTOS S.A.
        '24414', # DASS NORDESTE CALÇADOS E ARTIGOS ESPORTIVOS S.A
        '24473', # JHSF MALLS S.A.
        '24490', # SABER SERVIÇOS EDUCACIONAIS S.A.
        '2453',  # CIA ENERGETICA DE MINAS GERAIS - CEMIG
        '24546', # PRÁTICA KLIMAQUIP INDÚSTRIA E COMÉRCIO S.A.
        '24589', # ENERGISA TRANSMISSÃO DE ENERGIA S/A
        '24597', # CELEO REDES TRANSMISSÃO DE ENERGIA S.A.
        '2461',  # CENTRAIS ELET DE SANTA CATARINA S.A.
        '24627', # BLAU FARMACÊUTICA S.A.
        '24660', # BBM LOGÍSTICA S.A.
        '24694', # GRUPO SBF S.A.
        '24716', # VAMOS LOCAÇÃO DE CAMINHÕES, MÁQUINAS E EQUIPAMENTOS S.A.
        '24740', # COPEL GERAÇÃO E TRANSMISSÃO S.A.
        '24775', # BCBF PARTICIPAÇÕES S.A.
        '24783', # NATURA &CO HOLDING S.A.
        '24813', # LOCALIZA FLEET S.A.
        '24821', # REDE D'OR SÃO LUIZ S.A.
        '24830', # BRK AMBIENTAL PARTICIPAÇÕES S.A.
        '24848', # C&A MODAS S.A.
        '24856', # UP ENGENHARIA E URBANISMO S.A.
        '24872', # LIFEMED INDUSTRIAL DE EQUIP. E ART. MEDICOS E HOSP. S.A
        '2488',  # CERAMICA CHIARELLI SA
        '24902', # MITRE REALTY EMPREENDIMENTOS E PARTICIPAÇÕES S.A.
        '24910', # LOCAWEB SERVIÇOS DE INTERNET S.A.
        '24953', # ALLPARK EMPREENDIMENTOS, PARTICIPAÇÕES E SERVIÇOS S.A.
        '24961', # AMBIPAR PARTICIPAÇÕES E EMPREENDIMENTOS S.A.
        '25003', # SIMPAR S.A.
        '25011', # GRUPO DE MODA SOMA S.A.
        '25038', # LOJAS QUERO QUERO S.A.
        '25046', # D1000 VAREJO FARMA PARTICIPAÇÕES S.A.
        '25062', # LAVVI EMPREENDIMENTOS IMOBILIÁRIOS S.A.
        '25100', # CURY CONSTRUTORA E INCORPORADORA S.A.
        '25119', # MELNICK DESENVOLVIMENTO IMOBILIÁRIO S.A.
        '25127', # COMPASS GÁS E ENERGIA S.A.
        '25143', # PACAEMBU CONSTRUTORA S.A.
        '25160', # SEQUOIA LOGÍSTICA E TRANSPORTES S.A.
        '25186', # GRUPO MATEUS S.A.
        '25194', # TRIPLE PLAY BRASIL PARTICIPAÇÕES S.A.
        '25208', # TRACK & FIELD CO S.A.
        '25224', # 2W ENERGIA S.A.
        '25259', # ENJOEI S.A.
        '25275', # ALPHAVILLE S.A.
        '25283', # AERIS IND. E COM. DE EQUIP. PARA GER. DE ENG. S.A.
        '25291', # 3R PETROLEUM ÓLEO E GÁS S.A.
        '25305', # PATRIMAR ENGENHARIA S.A.
        '25321', # GRANBIO INVESTIMENTOS S.A.
        '25330', # ALLIED TECNOLOGIA S.A.
        '25348', # ELFA MEDICAMENTOS S.A.
        '25372', # SENDAS DISTRIBUIDORA S.A.
        '25399', # NEOGRID PARTICIPAÇÕES S.A.
        '25402', # HBR REALTY EMPREENDIMENTOS IMOBILIÁRIOS S.A.
        '25410', # SBF COMÉRCIO DE PRODUTOS ESPORTIVOS S.A.
        '25429', # FARMÁCIA E DROGARIA NISSEI S.A.
        '25437', # URBA DESENVOLVIMENTO URBANO S.A.
        '25445', # MPM CORPÓREOS S.A.
        '25453', # INTELBRAS S.A.
        '25461', # MOBLY S.A.
        '25470', # MOSAICO TECNOLOGIA AO CONSUMIDOR S.A.
        '25488', # FOCUS ENERGIA HOLDING PARTICIPAÇÕES S.A.
        '25526', # CRUZEIRO DO SUL EDUCACIONAL S.A.
        '25534', # OCEANPACT SERVIÇOS MARITIMOS S.A.
        '25542', # LOJAS LE BISCUIT S.A.
        '25550', # ORIZON VALORIZAÇÃO DE RESÍDUOS S.A.
        '25569', # ELETROMIDIA S.A.
        '25585', # CSN MINERAÇÃO S.A.
        '25658', # AGROGALAXY PARTICIPAÇÕES S.A.
        '25763', # VITTIA FERTILIZANTES E BIOLÓGICOS S.A.
        '25836', # DOTZ S.A.
        '25852', # W2W E-COMMERCE DE VINHOS S.A.
        '26166', # GRUPO FARTURA DE HORTIFRUT S.A.
        '2909',  # CIA CACIQUE CAFE SOLUVEL
        '3069',  # CIA FERRO LIGAS DA BAHIA - FERBASA
        '3077',  # CIA FIACAO TECIDOS CEDRO CACHOEIRA
        '3158',  # CIA TECIDOS NORTE DE MINAS COTEMINAS
        '3174',  # CIA DOCAS DE IMBITUBA
        '3182',  # DOCAS INVESTIMENTOS SA
        '3190',  # REDE ENERGIA PARTICIPAÇÕES S.A.
        '3204',  # CIA ESTADUAL DE TRANSMISSÃO DE ENERGIA ELETRICA - CEEE-T
        '3298',  # CIA HABITASUL DE PARTICIPACOES
        '3328',  # CIA HIDRO ELÉTRICA DO SÃO FRANCISCO
        '3336',  # CIA. IGUAÇU DE CAFÉ SOLÚVEL
        '3395',  # CIA INDUSTRIAL CATAGUASES
        '3549',  # CIA INDUSTRIAL SCHLOSSER S.A.
        '3654',  # CIA MELHORAMENTOS DE SAO PAULO
        '3980',  # GERDAU S.A.
        '4030',  # CIA SIDERURGICA NACIONAL
        '4057',  # SOUZA CRUZ SA
        '4081',  # CIA TECIDOS SANTANENSE
        '4146',  # KARSTEN S.A.
        '4170',  # VALE S.A.
        '4359',  # ELEKEIROZ S.A.
        '4448',  # COBRASMA S.A.
        '4537',  # GRAZZIOTIN S.A.
        '4650',  # CONFAB INDUSTRIAL SA
        '4669',  # GUARARAPES CONFECCOES S.A.
        '4707',  # CONSORCIO ALFA DE ADMINISTRACAO S.A.
        '4723',  # CONSTRUTORA ADOLPHO LINDENBERG S.A.
        '4774',  # CONSTRUTORA LIX DA CUNHA S.A.
        '4820',  # BRASKEM S.A.
        '4863',  # CORREA RIBEIRO S.A. COMERCIO E INDUSTRIA
        '5150',  # DHB IND E COMERCIO SA
        '5207',  # DOHLER S.A.
        '5258',  # RAIA DROGASIL S.A.
        '5312',  # MUNDIAL S.A. - PRODUTOS DE CONSUMO
        '5380',  # ELECTRO ACO ALTONA S.A.
        '5410',  # WEG S.A.
        '5762',  # ETERNIT S.A.
        '5770',  # EUCATEX S.A. INDUSTRIA E COMERCIO
        '5983',  # FIACAO TEC SAO JOSE S.A.
        '5991',  # VICUNHA TEXTIL SA
        '6173',  # TAURUS ARMAS S.A.
        '6211',  # FRAS-LE S.A.
        '6343',  # TUPY S.A.
        '6505',  # VIA S.A.
        '6700',  # HOTEIS OTHON S.A.
        '6815',  # IGB ELETRONICA S.A
        '701',   # BAHEMA EDUCAÇÃO S.A.
        '7510',  # INDUSTRIAS ROMI S.A.
        '7544',  # TEXTIL RENAUXVIEW S.A.
        '7595',  # INEPAR S.A. INDUSTRIA E CONSTRUCOES
        '7617',  # ITAÚSA S.A.
        '7811',  # JOAO FORTES ENGENHARIA S.A.
        '7870',  # KEPLER WEBER S.A.
        '80004', # TELEFÓNICA, S.A.
        '80020', # GP INVESTMENTS, LTD.
        '80047', # WILSON SONS LTD.
        '80071', # COSAN LIMITED
        '80080', # AGRENCO LIMITED
        '80098', # LAEP INVESTMENTS LTD
        '80101', # SOLVAY INDUPA SAIC
        '80110', # DUFRY A.G.
        '80128', # LATAM AIRLINES GROUP S.A.
        '80136', # TGLT S/A
        '80144', # PACIFIC RUBIALES ENERGY CORP.
        '80179', # BIOTOSCANA INVESTMENTS S.A.
        '80187', # AURA MINERALS INC.
        '80187', # AURA MINERALS INC.
        '8087',  # LOJAS AMERICANAS S.A.
        '8133',  # LOJAS RENNER S.A.
        '8192',  # TREVISA INVESTIMENTOS S.A.
        '8397',  # MANGELS INDUSTRIAL S.A.
        '8427',  # MANUFATURA DE BRINQUEDOS ESTRELA S.A.
        '8451',  # MARCOPOLO S.A.
        '8486',  # MARISOL SA
        '8575',  # MAHLE-METAL LEVE S.A.
        '8656',  # METALURGICA GERDAU S.A.
        '8672',  # IGUATEMI S.A.
        '8745',  # METANOR SA METANOL DO NE
        '8753',  # METISA METALURGICA TIMBOENSE S.A.
        '8893',  # MONTEIRO ARANHA S.A.
        '90212', # MULTILASER INDUSTRIAL S.A.
        '9040',  # NADIR FIGUEIREDO IND E COM S.A.
        '9067',  # SUZANO HOLDING S.A.
        '9342',  # DIMED S.A. DISTRIBUIDORA DE MEDICAMENTOS
        '9393',  # PARANAPANEMA S.A.
        '94',    # PANATLANTICA S.A.
        '9415',  # SAO PAULO TURISMO S.A.
        '9512',  # PETROLEO BRASILEIRO S.A. PETROBRAS
        '9539',  # PETTENATI S.A. INDUSTRIA TEXTIL
        '9784',  # PRONOR PETROQUIMICA SA
        '9857',  # QGN PARTICIPAÇÕES SA
        '9954',  # ALFA HOLDINGS S.A.
        '9989',  # REFINARIA DE PETROLEOS MANGUINHOS S.A.
    ]

def cvm_codes() -> typing.List[str]:
    """
    Returns CVM codes of companies that use the account layout
    of companies which are neither financial institutions nor
    insurance companies.
    """

    return _cvm_codes().copy()