"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagPack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Base class for all rule sets.
 *
 * @stability stable
 */
class NagPack {
    /**
     * @stability stable
     */
    constructor(props) {
        this.verbose =
            props == undefined || props.verbose == undefined ? false : props.verbose;
    }
    /**
     * Check whether a specific rule should be ignored.
     *
     * @param ignores ignores listed in cdkNag metadata.
     * @param ruleId the id of the rule to ignore.
     * @returns boolean
     * @stability stable
     */
    ignoreRule(ignores, ruleId) {
        if (ignores) {
            for (let ignore of ignores) {
                if (ignore.id &&
                    ignore.reason &&
                    JSON.stringify(ignore.reason).length >= 10 &&
                    ignore.id == ruleId) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * The message to output to the console when a rule is triggered.
     *
     * @param ruleId the id of the rule.
     * @param info why the rule was triggered.
     * @param explanation why the rule exists.
     * @returns string
     * @stability stable
     */
    createMessage(ruleId, info, explanation) {
        let message = `${ruleId}: ${info}`;
        return this.verbose ? `${message} ${explanation}` : message;
    }
}
exports.NagPack = NagPack;
_a = JSII_RTTI_SYMBOL_1;
NagPack[_a] = { fqn: "monocdk-nag.NagPack", version: "0.0.107" };
//# sourceMappingURL=data:application/json;base64,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