import { IAspect, IConstruct } from 'monocdk';
/**
 * Interface for creating a Nag rule set.
 *
 * @stability stable
 */
export interface NagPackProps {
    /**
     * Whether or not to enable extended explanatory descriptions on warning and error messages.
     *
     * @stability stable
     */
    readonly verbose?: boolean;
}
/**
 * Base class for all rule sets.
 *
 * @stability stable
 */
export declare abstract class NagPack implements IAspect {
    /**
     * @stability stable
     */
    protected verbose: boolean;
    /**
     * @stability stable
     */
    constructor(props?: NagPackProps);
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    abstract visit(node: IConstruct): void;
    /**
     * Check whether a specific rule should be ignored.
     *
     * @param ignores ignores listed in cdkNag metadata.
     * @param ruleId the id of the rule to ignore.
     * @returns boolean
     * @stability stable
     */
    ignoreRule(ignores: any, ruleId: string): boolean;
    /**
     * The message to output to the console when a rule is triggered.
     *
     * @param ruleId the id of the rule.
     * @param info why the rule was triggered.
     * @param explanation why the rule exists.
     * @returns string
     * @stability stable
     */
    createMessage(ruleId: string, info: string, explanation: string): string;
}
