"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets have server access logs enabled - (Control IDs: AC-2(g), AU-2(a)(d), AU-3, AU-12(a)(c))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const logging = monocdk_1.Stack.of(node).resolve(node.loggingConfiguration);
        if (logging == undefined ||
            (logging.destinationBucketName == undefined &&
                logging.logFilePrefix == undefined)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzUzNCdWNrZXRMb2dnaW5nRW5hYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9OSVNULTgwMC01My9ydWxlcy9zMy9uaXN0ODAwNTNTM0J1Y2tldExvZ2dpbmdFbmFibGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLDJDQUEyQztBQUUzQzs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksa0JBQVMsRUFBRTtRQUM3QixNQUFNLE9BQU8sR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUNsRSxJQUNFLE9BQU8sSUFBSSxTQUFTO1lBQ3BCLENBQUMsT0FBTyxDQUFDLHFCQUFxQixJQUFJLFNBQVM7Z0JBQ3pDLE9BQU8sQ0FBQyxhQUFhLElBQUksU0FBUyxDQUFDLEVBQ3JDO1lBQ0EsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBWkQsNEJBWUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuQnVja2V0IH0gZnJvbSAnbW9ub2Nkay9hd3MtczMnO1xuXG4vKipcbiAqIFMzIEJ1Y2tldHMgaGF2ZSBzZXJ2ZXIgYWNjZXNzIGxvZ3MgZW5hYmxlZCAtIChDb250cm9sIElEczogQUMtMihnKSwgQVUtMihhKShkKSwgQVUtMywgQVUtMTIoYSkoYykpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuQnVja2V0KSB7XG4gICAgY29uc3QgbG9nZ2luZyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5sb2dnaW5nQ29uZmlndXJhdGlvbik7XG4gICAgaWYgKFxuICAgICAgbG9nZ2luZyA9PSB1bmRlZmluZWQgfHxcbiAgICAgIChsb2dnaW5nLmRlc3RpbmF0aW9uQnVja2V0TmFtZSA9PSB1bmRlZmluZWQgJiZcbiAgICAgICAgbG9nZ2luZy5sb2dGaWxlUHJlZml4ID09IHVuZGVmaW5lZClcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=