"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets have object lock enabled - (Control ID: SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const objectLockEnabled = monocdk_1.Stack.of(node).resolve(node.objectLockEnabled);
        const objectLockConfiguration = monocdk_1.Stack.of(node).resolve(node.objectLockConfiguration);
        if (objectLockEnabled !== true ||
            objectLockConfiguration === undefined ||
            objectLockConfiguration.objectLockEnabled !== 'Enabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzUzNCdWNrZXREZWZhdWx0TG9ja0VuYWJsZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvczMvbmlzdDgwMDUzUzNCdWNrZXREZWZhdWx0TG9ja0VuYWJsZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsMkNBQTJDO0FBRTNDOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLE1BQU0saUJBQWlCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDekUsTUFBTSx1QkFBdUIsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FDcEQsSUFBSSxDQUFDLHVCQUF1QixDQUM3QixDQUFDO1FBQ0YsSUFDRSxpQkFBaUIsS0FBSyxJQUFJO1lBQzFCLHVCQUF1QixLQUFLLFNBQVM7WUFDckMsdUJBQXVCLENBQUMsaUJBQWlCLEtBQUssU0FBUyxFQUN2RDtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWZELDRCQWVDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkJ1Y2tldCB9IGZyb20gJ21vbm9jZGsvYXdzLXMzJztcblxuLyoqXG4gKiBTMyBCdWNrZXRzIGhhdmUgb2JqZWN0IGxvY2sgZW5hYmxlZCAtIChDb250cm9sIElEOiBTQy0yOClcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5CdWNrZXQpIHtcbiAgICBjb25zdCBvYmplY3RMb2NrRW5hYmxlZCA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5vYmplY3RMb2NrRW5hYmxlZCk7XG4gICAgY29uc3Qgb2JqZWN0TG9ja0NvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbm9kZS5vYmplY3RMb2NrQ29uZmlndXJhdGlvbixcbiAgICApO1xuICAgIGlmIChcbiAgICAgIG9iamVjdExvY2tFbmFibGVkICE9PSB0cnVlIHx8XG4gICAgICBvYmplY3RMb2NrQ29uZmlndXJhdGlvbiA9PT0gdW5kZWZpbmVkIHx8XG4gICAgICBvYmplY3RMb2NrQ29uZmlndXJhdGlvbi5vYmplY3RMb2NrRW5hYmxlZCAhPT0gJ0VuYWJsZWQnXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19