"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
/**
 * RDS DB instances have enhanced monitoring enabled - (Control ID: CA-7(a)(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const enhancedMonitoring = node.monitoringInterval;
        if (enhancedMonitoring == undefined || enhancedMonitoring <= 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzUkRTRW5oYW5jZWRNb25pdG9yaW5nRW5hYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9OSVNULTgwMC01My9ydWxlcy9yZHMvbmlzdDgwMDUzUkRTRW5oYW5jZWRNb25pdG9yaW5nRW5hYmxlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLDZDQUFnRDtBQUVoRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksdUJBQWEsRUFBRTtRQUNqQyxNQUFNLGtCQUFrQixHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztRQUNuRCxJQUFJLGtCQUFrQixJQUFJLFNBQVMsSUFBSSxrQkFBa0IsSUFBSSxDQUFDLEVBQUU7WUFDOUQsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBUkQsNEJBUUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5EQkluc3RhbmNlIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcblxuLyoqXG4gKiBSRFMgREIgaW5zdGFuY2VzIGhhdmUgZW5oYW5jZWQgbW9uaXRvcmluZyBlbmFibGVkIC0gKENvbnRyb2wgSUQ6IENBLTcoYSkoYikpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuREJJbnN0YW5jZSkge1xuICAgIGNvbnN0IGVuaGFuY2VkTW9uaXRvcmluZyA9IG5vZGUubW9uaXRvcmluZ0ludGVydmFsO1xuICAgIGlmIChlbmhhbmNlZE1vbml0b3JpbmcgPT0gdW5kZWZpbmVkIHx8IGVuaGFuY2VkTW9uaXRvcmluZyA8PSAwKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19