"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_lambda_1 = require("monocdk/aws-lambda");
/**
 * Lambda functions are VPC enabled - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_lambda_1.CfnFunction) {
        //Check for a VPC configuration
        const vpcConfig = monocdk_1.Stack.of(node).resolve(node.vpcConfig);
        if (vpcConfig == undefined) {
            return false;
        }
        else {
            const secgroups = monocdk_1.Stack.of(node).resolve(vpcConfig.securityGroupIds);
            const subnets = monocdk_1.Stack.of(node).resolve(vpcConfig.subnetIds);
            //Does this function exist within at least one VPC security group or subnet?
            if (secgroups == undefined || secgroups.length == 0) {
                if (subnets == undefined || subnets.length == 0) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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