"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM policies are not attached at the user level - (Control IDs: AC-2(j), AC-3, AC-5c, AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        const policyUsers = monocdk_1.Stack.of(node).resolve(node.users);
        if (policyUsers != undefined) {
            return false;
        }
    }
    else if (node instanceof aws_iam_1.CfnUser) {
        const policies = monocdk_1.Stack.of(node).resolve(node.policies);
        const managedPolicyArns = monocdk_1.Stack.of(node).resolve(node.managedPolicyArns);
        if (policies != undefined || managedPolicyArns != undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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