"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
/**
 * EC2 instances are created within VPCs - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        //If we are in a VPC, then we'll have a subnet
        const subnetId = monocdk_1.Stack.of(node).resolve(node.subnetId);
        if (subnetId == undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzRUMyQ2hlY2tJbnNpZGVWUEMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvZWMyL25pc3Q4MDA1M0VDMkNoZWNrSW5zaWRlVlBDLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0VBR0U7O0FBRUYscUNBQTRDO0FBQzVDLDZDQUE4QztBQUU5Qzs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBZ0I7SUFDdkMsSUFBSSxJQUFJLFlBQVkscUJBQVcsRUFBRTtRQUMvQiw4Q0FBOEM7UUFDOUMsTUFBTSxRQUFRLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3ZELElBQUksUUFBUSxJQUFJLFNBQVMsRUFBRTtZQUN6QixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFURCw0QkFTQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuXG5pbXBvcnQgeyBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuSW5zdGFuY2UgfSBmcm9tICdtb25vY2RrL2F3cy1lYzInO1xuXG4vKipcbiAqIEVDMiBpbnN0YW5jZXMgYXJlIGNyZWF0ZWQgd2l0aGluIFZQQ3MgLSAoQ29udHJvbCBJRHM6IEFDLTQsIFNDLTcsIFNDLTcoMykpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IElDb25zdHJ1Y3QpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5JbnN0YW5jZSkge1xuICAgIC8vSWYgd2UgYXJlIGluIGEgVlBDLCB0aGVuIHdlJ2xsIGhhdmUgYSBzdWJuZXRcbiAgICBjb25zdCBzdWJuZXRJZCA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5zdWJuZXRJZCk7XG4gICAgaWYgKHN1Ym5ldElkID09IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==