"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_codebuild_1 = require("monocdk/aws-codebuild");
/**
 * CodeBuild projects DO NOT store AWS credentials as plaintext environment variables - (Control IDs: AC-6, IA-5(7), SA-3(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                if (resolvedEnvVar.name == 'AWS_ACCESS_KEY_ID' ||
                    resolvedEnvVar.name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (resolvedEnvVar.type == undefined ||
                        resolvedEnvVar.type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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