"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets prohibit public read access through their Block Public Access configurations and bucket ACLs - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const publicAccessBlockConfiguration = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        if (publicAccessBlockConfiguration === undefined ||
            publicAccessBlockConfiguration.blockPublicPolicy !== true) {
            return false;
        }
        const accessControl = monocdk_1.Stack.of(node).resolve(node.accessControl);
        if ((accessControl === 'PublicRead' || accessControl === 'PublicReadWrite') &&
            publicAccessBlockConfiguration.blockPublicAcls !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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