"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch - (Control IDs: 164.308(a)(3)(ii)(A), 164.308(a)(5)(ii)(C))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.engine));
        const dbLogs = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return false;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery'))) {
                return false;
            }
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade'))) {
                return false;
            }
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace'))) {
                return false;
            }
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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