"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
/**
 *  Non-Aurora RDS DB instances have multi-AZ support enabled - (Control IDs: 164.308(a)(7)(i), 164.308(a)(7)(ii)(C))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const multiAz = monocdk_1.Stack.of(node).resolve(node.multiAz);
        if (!multiAz &&
            (node.engine == undefined ||
                !node.engine.toLowerCase().includes('aurora'))) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eVJEU0luc3RhbmNlTXVsdGlBWlN1cHBvcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvSElQQUEtU2VjdXJpdHkvcnVsZXMvcmRzL2hpcGFhU2VjdXJpdHlSRFNJbnN0YW5jZU11bHRpQVpTdXBwb3J0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLDZDQUFnRDtBQUVoRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksdUJBQWEsRUFBRTtRQUNqQyxNQUFNLE9BQU8sR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDckQsSUFDRSxDQUFDLE9BQU87WUFDUixDQUFDLElBQUksQ0FBQyxNQUFNLElBQUksU0FBUztnQkFDdkIsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUNoRDtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVpELDRCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkRCSW5zdGFuY2UgfSBmcm9tICdtb25vY2RrL2F3cy1yZHMnO1xuXG4vKipcbiAqICBOb24tQXVyb3JhIFJEUyBEQiBpbnN0YW5jZXMgaGF2ZSBtdWx0aS1BWiBzdXBwb3J0IGVuYWJsZWQgLSAoQ29udHJvbCBJRHM6IDE2NC4zMDgoYSkoNykoaSksIDE2NC4zMDgoYSkoNykoaWkpKEMpKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRCSW5zdGFuY2UpIHtcbiAgICBjb25zdCBtdWx0aUF6ID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLm11bHRpQXopO1xuICAgIGlmIChcbiAgICAgICFtdWx0aUF6ICYmXG4gICAgICAobm9kZS5lbmdpbmUgPT0gdW5kZWZpbmVkIHx8XG4gICAgICAgICFub2RlLmVuZ2luZS50b0xvd2VyQ2FzZSgpLmluY2x1ZGVzKCdhdXJvcmEnKSlcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=