"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM policies do not grant admin access - (Control IDs: 164.308(a)(3)(i), 164.308(a)(3)(ii)(A), 164.308(a)(3)(ii)(B), 164.308(a)(4)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(B), 164.308(a)(4)(ii)(C), 164.312(a)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        if (checkDocument(node, node.policyDocument)) {
            return false;
        }
    }
    else if (node instanceof aws_iam_1.CfnGroup || node instanceof aws_iam_1.CfnRole) {
        if (node.policies != undefined && checkDocument(node, node.policies)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy document
 * @param node the CfnResource to Check
 * @param policyDoc the JSON policy document
 * @returns boolean
 */
function checkDocument(node, policyDoc) {
    const resolvedDoc = monocdk_1.Stack.of(node).resolve(policyDoc);
    const reg = /"Action":\[?(.*,)?"\*"(,.*)?\]?,"Effect":"Allow","Resource":\[?(.*,)?"(?:arn(?::.*(?::)?)?)?\*"(,.*)?\]?/gm;
    if (JSON.stringify(resolvedDoc).search(reg) != -1) {
        return true;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,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