"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
/**
 * ALBs, NLBs, and GLBs have deletion protection enabled - (Control IDs: 164.308(a)(7)(i), 164.308(a)(7)(ii)(C))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
        if (attributes != undefined) {
            var deletionProtectionEnabled = false;
            for (const attr of attributes) {
                const resolvedAttr = monocdk_1.Stack.of(node).resolve(attr);
                if (resolvedAttr.key != undefined &&
                    resolvedAttr.key == 'deletion_protection.enabled') {
                    if (resolvedAttr.value == 'true') {
                        deletionProtectionEnabled = true;
                    }
                }
            }
            if (!deletionProtectionEnabled) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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