"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
/**
 * Application Load Balancers are enabled to drop invalid headers - (Control IDs: 164.312(a)(2)(iv), 164.312(e)(1), 164.312(e)(2)(i), 164.312(e)(2)(ii))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const type = monocdk_1.Stack.of(node).resolve(node.type);
        if (type == undefined || type == 'application') {
            const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
            if (attributes != undefined) {
                const reg = /"routing\.http\.drop_invalid_header_fields\.enabled","value":"true"/gm;
                if (JSON.stringify(attributes).search(reg) == -1) {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eUFMQkh0dHBEcm9wSW52YWxpZEhlYWRlckVuYWJsZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvSElQQUEtU2VjdXJpdHkvcnVsZXMvZWxiL2hpcGFhU2VjdXJpdHlBTEJIdHRwRHJvcEludmFsaWRIZWFkZXJFbmFibGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0VBR0U7O0FBRUYscUNBQTRDO0FBQzVDLG1GQUFxRTtBQUVyRTs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBZ0I7SUFDdkMsSUFBSSxJQUFJLFlBQVksNENBQWUsRUFBRTtRQUNuQyxNQUFNLElBQUksR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDL0MsSUFBSSxJQUFJLElBQUksU0FBUyxJQUFJLElBQUksSUFBSSxhQUFhLEVBQUU7WUFDOUMsTUFBTSxVQUFVLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLENBQUM7WUFDdkUsSUFBSSxVQUFVLElBQUksU0FBUyxFQUFFO2dCQUMzQixNQUFNLEdBQUcsR0FDUCx1RUFBdUUsQ0FBQztnQkFDMUUsSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRTtvQkFDaEQsT0FBTyxLQUFLLENBQUM7aUJBQ2Q7YUFDRjtpQkFBTTtnQkFDTCxPQUFPLEtBQUssQ0FBQzthQUNkO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWpCRCw0QkFpQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cblxuaW1wb3J0IHsgSUNvbnN0cnVjdCwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkxvYWRCYWxhbmNlciB9IGZyb20gJ21vbm9jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjInO1xuXG4vKipcbiAqIEFwcGxpY2F0aW9uIExvYWQgQmFsYW5jZXJzIGFyZSBlbmFibGVkIHRvIGRyb3AgaW52YWxpZCBoZWFkZXJzIC0gKENvbnRyb2wgSURzOiAxNjQuMzEyKGEpKDIpKGl2KSwgMTY0LjMxMihlKSgxKSwgMTY0LjMxMihlKSgyKShpKSwgMTY0LjMxMihlKSgyKShpaSkpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IElDb25zdHJ1Y3QpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Mb2FkQmFsYW5jZXIpIHtcbiAgICBjb25zdCB0eXBlID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLnR5cGUpO1xuICAgIGlmICh0eXBlID09IHVuZGVmaW5lZCB8fCB0eXBlID09ICdhcHBsaWNhdGlvbicpIHtcbiAgICAgIGNvbnN0IGF0dHJpYnV0ZXMgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUubG9hZEJhbGFuY2VyQXR0cmlidXRlcyk7XG4gICAgICBpZiAoYXR0cmlidXRlcyAhPSB1bmRlZmluZWQpIHtcbiAgICAgICAgY29uc3QgcmVnID1cbiAgICAgICAgICAvXCJyb3V0aW5nXFwuaHR0cFxcLmRyb3BfaW52YWxpZF9oZWFkZXJfZmllbGRzXFwuZW5hYmxlZFwiLFwidmFsdWVcIjpcInRydWVcIi9nbTtcbiAgICAgICAgaWYgKEpTT04uc3RyaW5naWZ5KGF0dHJpYnV0ZXMpLnNlYXJjaChyZWcpID09IC0xKSB7XG4gICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19