"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_codebuild_1 = require("monocdk/aws-codebuild");
/**
 * CodeBuild projects do not store AWS credentials as plaintext environment variables - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                if (resolvedEnvVar.name == 'AWS_ACCESS_KEY_ID' ||
                    resolvedEnvVar.name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (resolvedEnvVar.type == undefined ||
                        resolvedEnvVar.type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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