"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_cloudwatch_1 = require("monocdk/aws-cloudwatch");
/**
 * CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudwatch_1.CfnAlarm) {
        const actionsEnabled = monocdk_1.Stack.of(node).resolve(node.actionsEnabled);
        if (actionsEnabled === false) {
            return false;
        }
        // Actions can be an array with a token that then resolves to an empty array or undefined
        const alarmActions = monocdk_1.Stack.of(node).resolve(node.alarmActions);
        const insufficientDataActions = monocdk_1.Stack.of(node).resolve(node.insufficientDataActions);
        const okActions = monocdk_1.Stack.of(node).resolve(node.okActions);
        const totalAlarmActions = alarmActions ? alarmActions.length : 0;
        const totalInsufficientDataActions = insufficientDataActions
            ? insufficientDataActions.length
            : 0;
        const totalOkActions = okActions ? okActions.length : 0;
        const totalActions = totalAlarmActions + totalInsufficientDataActions + totalOkActions;
        if (totalActions == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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