"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
/**
 * CloudFront distributions use an origin access identity for S3 origins
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.origins != undefined) {
            const origins = monocdk_1.Stack.of(node).resolve(distributionConfig.origins);
            for (const origin of origins) {
                const resolvedOrigin = monocdk_1.Stack.of(node).resolve(origin);
                const resolvedDomainName = monocdk_1.Stack.of(node).resolve(resolvedOrigin.domainName);
                const s3Regex = /^.+\.s3(?:-website)?(?:\..+)?(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))$/;
                if (s3Regex.test(resolvedDomainName)) {
                    if (resolvedOrigin.s3OriginConfig == undefined) {
                        return false;
                    }
                    const resolvedConfig = monocdk_1.Stack.of(node).resolve(resolvedOrigin.s3OriginConfig);
                    if (resolvedConfig.originAccessIdentity == undefined ||
                        resolvedConfig.originAccessIdentity.replace(/\s/g, '').length == 0) {
                        return false;
                    }
                }
            }
        }
    }
    else if (node instanceof aws_cloudfront_1.CfnStreamingDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.streamingDistributionConfig);
        const resolvedOrigin = monocdk_1.Stack.of(node).resolve(distributionConfig.s3Origin);
        if (resolvedOrigin.originAccessIdentity.replace(/\s/g, '').length == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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