"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
/**
 * CloudFront distributions do not use SSLv3 or TLSv1 for communication to the origin
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.origins != undefined) {
            const origins = monocdk_1.Stack.of(node).resolve(distributionConfig.origins);
            for (const origin of origins) {
                const resolvedOrigin = monocdk_1.Stack.of(node).resolve(origin);
                if (resolvedOrigin.customOriginConfig != undefined) {
                    const customOriginConfig = monocdk_1.Stack.of(node).resolve(resolvedOrigin.customOriginConfig);
                    if (customOriginConfig.originProtocolPolicy !=
                        aws_cloudfront_1.OriginProtocolPolicy.HTTPS_ONLY) {
                        return false;
                    }
                    if (customOriginConfig.originSslProtocols == undefined) {
                        return false;
                    }
                    const outdatedValues = [
                        aws_cloudfront_1.SecurityPolicyProtocol.SSL_V3,
                        aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1,
                    ];
                    const originSslProtocols = (monocdk_1.Stack.of(node).resolve(customOriginConfig.originSslProtocols));
                    const lowerCaseProtocols = originSslProtocols.map((i) => {
                        return i.toLowerCase();
                    });
                    for (const outdated of outdatedValues) {
                        if (lowerCaseProtocols.includes(outdated.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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