"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
/**
 *  RDS DB instances and Aurora DB clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.port == undefined) {
            return false;
        }
        const port = monocdk_1.Stack.of(node).resolve(node.port);
        const engine = node.engine.toLowerCase();
        if (node.engineMode == undefined ||
            node.engineMode.toLowerCase() == 'provisioned') {
            if (engine.includes('aurora') && port == 3306) {
                return false;
            }
        }
        else if ((engine == 'aurora' || engine == 'aurora-mysql') &&
            port == 3306) {
            return false;
        }
        else if (engine == 'aurora-postgresql' && port == 5432) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        if (node.engine == undefined) {
            return false;
        }
        const port = monocdk_1.Stack.of(node).resolve(node.port);
        const engine = node.engine.toLowerCase();
        if (port == undefined) {
            if (!engine.includes('aurora')) {
                return false;
            }
        }
        else {
            if ((engine == 'mariadb' || engine == 'mysql') && port == 3306) {
                return false;
            }
            else if (engine == 'postgres' && port == 5432) {
                return false;
            }
            else if (engine.includes('oracle') && port == 1521) {
                return false;
            }
            else if (engine.includes('sqlserver') && port == 1433) {
                return false;
            }
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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