"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_neptune_1 = require("monocdk/aws-neptune");
/**
 * Neptune DB clusters have a reasonable minimum backup retention period configured
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_neptune_1.CfnDBCluster) {
        if (node.backupRetentionPeriod == undefined ||
            node.backupRetentionPeriod < 7) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTjMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9OMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLHFEQUFtRDtBQUVuRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksMEJBQVksRUFBRTtRQUNoQyxJQUNFLElBQUksQ0FBQyxxQkFBcUIsSUFBSSxTQUFTO1lBQ3ZDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxDQUFDLEVBQzlCO1lBQ0EsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBVkQsNEJBVUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5EQkNsdXN0ZXIgfSBmcm9tICdtb25vY2RrL2F3cy1uZXB0dW5lJztcblxuLyoqXG4gKiBOZXB0dW5lIERCIGNsdXN0ZXJzIGhhdmUgYSByZWFzb25hYmxlIG1pbmltdW0gYmFja3VwIHJldGVudGlvbiBwZXJpb2QgY29uZmlndXJlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRCQ2x1c3Rlcikge1xuICAgIGlmIChcbiAgICAgIG5vZGUuYmFja3VwUmV0ZW50aW9uUGVyaW9kID09IHVuZGVmaW5lZCB8fFxuICAgICAgbm9kZS5iYWNrdXBSZXRlbnRpb25QZXJpb2QgPCA3XG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19