"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecs_1 = require("monocdk/aws-ecs");
/**
 * ECS Cluster has CloudWatch Container Insights Enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnCluster) {
        if (node.clusterSettings == undefined) {
            return false;
        }
        const clusterSettings = monocdk_1.Stack.of(node).resolve(node.clusterSettings);
        for (const setting of clusterSettings) {
            const resolvedSetting = monocdk_1.Stack.of(node).resolve(setting);
            if (resolvedSetting.name &&
                resolvedSetting.name == 'containerInsights' &&
                resolvedSetting.value &&
                resolvedSetting.value == 'enabled') {
                return true;
            }
        }
        return false;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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